<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LWLANProfile StructType
 * @subpackage Structs
 */
class LWLANProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ssid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ssid;
    /**
     * The frequencyBand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $frequencyBand;
    /**
     * The userModifiable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userModifiable;
    /**
     * The authMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authMethod;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pskPassphrase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassphrase;
    /**
     * The wepKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $passwordDescription;
    /**
     * The networkAccessProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $networkAccessProfile;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LWLANProfile
     * @uses LWLANProfile::setName()
     * @uses LWLANProfile::setDescription()
     * @uses LWLANProfile::setSsid()
     * @uses LWLANProfile::setFrequencyBand()
     * @uses LWLANProfile::setUserModifiable()
     * @uses LWLANProfile::setAuthMethod()
     * @uses LWLANProfile::setUserName()
     * @uses LWLANProfile::setPassword()
     * @uses LWLANProfile::setPskPassphrase()
     * @uses LWLANProfile::setWepKey()
     * @uses LWLANProfile::setPasswordDescription()
     * @uses LWLANProfile::setNetworkAccessProfile()
     * @uses LWLANProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ssid
     * @param string $frequencyBand
     * @param string $userModifiable
     * @param string $authMethod
     * @param string $userName
     * @param string $password
     * @param string $pskPassphrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ssid = null, $frequencyBand = null, $userModifiable = null, $authMethod = null, $userName = null, $password = null, $pskPassphrase = null, $wepKey = null, $passwordDescription = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSsid($ssid)
            ->setFrequencyBand($frequencyBand)
            ->setUserModifiable($userModifiable)
            ->setAuthMethod($authMethod)
            ->setUserName($userName)
            ->setPassword($password)
            ->setPskPassphrase($pskPassphrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setNetworkAccessProfile($networkAccessProfile)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssid value
     * @return string|null
     */
    public function getSsid()
    {
        return $this->ssid;
    }
    /**
     * Set ssid value
     * @param string $ssid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setSsid($ssid = null)
    {
        // validation for constraint: string
        if (!is_null($ssid) && !is_string($ssid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssid, true), gettype($ssid)), __LINE__);
        }
        $this->ssid = $ssid;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setFrequencyBand($frequencyBand = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency', is_array($frequencyBand) ? implode(', ', $frequencyBand) : var_export($frequencyBand, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setUserModifiable($userModifiable = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges', is_array($userModifiable) ? implode(', ', $userModifiable) : var_export($userModifiable, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get authMethod value
     * @return string|null
     */
    public function getAuthMethod()
    {
        return $this->authMethod;
    }
    /**
     * Set authMethod value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiAuthenticationMethod::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setAuthMethod($authMethod = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWiFiAuthenticationMethod::valueIsValid($authMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiAuthenticationMethod', is_array($authMethod) ? implode(', ', $authMethod) : var_export($authMethod, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authMethod = $authMethod;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pskPassphrase value
     * @return string|null
     */
    public function getPskPassphrase()
    {
        return $this->pskPassphrase;
    }
    /**
     * Set pskPassphrase value
     * @param string $pskPassphrase
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setPskPassphrase($pskPassphrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassphrase) && !is_string($pskPassphrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pskPassphrase, true), gettype($pskPassphrase)), __LINE__);
        }
        $this->pskPassphrase = $pskPassphrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wepKey, true), gettype($wepKey)), __LINE__);
        }
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordDescription, true), gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get networkAccessProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNetworkAccessProfile()
    {
        return $this->networkAccessProfile;
    }
    /**
     * Set networkAccessProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setNetworkAccessProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile = null)
    {
        $this->networkAccessProfile = $networkAccessProfile;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LWLANProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
