<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVpnProfile StructType
 * @subpackage Structs
 */
class LVpnProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The autoNetworkDetection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoNetworkDetection;
    /**
     * The mtu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtu;
    /**
     * The failToConnect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $failToConnect;
    /**
     * The clientAuthentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientAuthentication;
    /**
     * The pwdPersistant
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdPersistant;
    /**
     * The enableHostIdCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableHostIdCheck;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVpnProfile
     * @uses LVpnProfile::setName()
     * @uses LVpnProfile::setDescription()
     * @uses LVpnProfile::setAutoNetworkDetection()
     * @uses LVpnProfile::setMtu()
     * @uses LVpnProfile::setFailToConnect()
     * @uses LVpnProfile::setClientAuthentication()
     * @uses LVpnProfile::setPwdPersistant()
     * @uses LVpnProfile::setEnableHostIdCheck()
     * @uses LVpnProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $autoNetworkDetection
     * @param string $mtu
     * @param string $failToConnect
     * @param string $clientAuthentication
     * @param string $pwdPersistant
     * @param string $enableHostIdCheck
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $autoNetworkDetection = null, $mtu = null, $failToConnect = null, $clientAuthentication = null, $pwdPersistant = null, $enableHostIdCheck = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAutoNetworkDetection($autoNetworkDetection)
            ->setMtu($mtu)
            ->setFailToConnect($failToConnect)
            ->setClientAuthentication($clientAuthentication)
            ->setPwdPersistant($pwdPersistant)
            ->setEnableHostIdCheck($enableHostIdCheck)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoNetworkDetection value
     * @return string|null
     */
    public function getAutoNetworkDetection()
    {
        return $this->autoNetworkDetection;
    }
    /**
     * Set autoNetworkDetection value
     * @param string $autoNetworkDetection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setAutoNetworkDetection($autoNetworkDetection = null)
    {
        // validation for constraint: string
        if (!is_null($autoNetworkDetection) && !is_string($autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoNetworkDetection, true), gettype($autoNetworkDetection)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($autoNetworkDetection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($autoNetworkDetection, true)), __LINE__);
        }
        $this->autoNetworkDetection = $autoNetworkDetection;
        return $this;
    }
    /**
     * Get mtu value
     * @return string|null
     */
    public function getMtu()
    {
        return $this->mtu;
    }
    /**
     * Set mtu value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtu
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setMtu($mtu = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($mtu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($mtu) ? implode(', ', $mtu) : var_export($mtu, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mtu = $mtu;
        return $this;
    }
    /**
     * Get failToConnect value
     * @return string|null
     */
    public function getFailToConnect()
    {
        return $this->failToConnect;
    }
    /**
     * Set failToConnect value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failToConnect
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setFailToConnect($failToConnect = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($failToConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($failToConnect) ? implode(', ', $failToConnect) : var_export($failToConnect, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failToConnect = $failToConnect;
        return $this;
    }
    /**
     * Get clientAuthentication value
     * @return string|null
     */
    public function getClientAuthentication()
    {
        return $this->clientAuthentication;
    }
    /**
     * Set clientAuthentication value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVPNClientAuthentication::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVPNClientAuthentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setClientAuthentication($clientAuthentication = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XVPNClientAuthentication::valueIsValid($clientAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XVPNClientAuthentication', is_array($clientAuthentication) ? implode(', ', $clientAuthentication) : var_export($clientAuthentication, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XVPNClientAuthentication::getValidValues())), __LINE__);
        }
        $this->clientAuthentication = $clientAuthentication;
        return $this;
    }
    /**
     * Get pwdPersistant value
     * @return string|null
     */
    public function getPwdPersistant()
    {
        return $this->pwdPersistant;
    }
    /**
     * Set pwdPersistant value
     * @param string $pwdPersistant
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setPwdPersistant($pwdPersistant = null)
    {
        // validation for constraint: string
        if (!is_null($pwdPersistant) && !is_string($pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwdPersistant, true), gettype($pwdPersistant)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pwdPersistant) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pwdPersistant, true)), __LINE__);
        }
        $this->pwdPersistant = $pwdPersistant;
        return $this;
    }
    /**
     * Get enableHostIdCheck value
     * @return string|null
     */
    public function getEnableHostIdCheck()
    {
        return $this->enableHostIdCheck;
    }
    /**
     * Set enableHostIdCheck value
     * @param string $enableHostIdCheck
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setEnableHostIdCheck($enableHostIdCheck = null)
    {
        // validation for constraint: string
        if (!is_null($enableHostIdCheck) && !is_string($enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableHostIdCheck, true), gettype($enableHostIdCheck)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableHostIdCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableHostIdCheck, true)), __LINE__);
        }
        $this->enableHostIdCheck = $enableHostIdCheck;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
