<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVpnGroupMember StructType
 * @subpackage Structs
 */
class LVpnGroupMember extends AbstractStructBase
{
    /**
     * The vpnGatewayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnGatewayName;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVpnGroupMember
     * @uses LVpnGroupMember::setVpnGatewayName()
     * @uses LVpnGroupMember::setPriority()
     * @uses LVpnGroupMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGatewayName
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGatewayName = null, $priority = null, $uuid = null)
    {
        $this
            ->setVpnGatewayName($vpnGatewayName)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get vpnGatewayName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnGatewayName()
    {
        return $this->vpnGatewayName;
    }
    /**
     * Set vpnGatewayName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGatewayName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGroupMember
     */
    public function setVpnGatewayName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGatewayName = null)
    {
        $this->vpnGatewayName = $vpnGatewayName;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
