<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVpnGatewayMember StructType
 * @subpackage Structs
 */
class LVpnGatewayMember extends AbstractStructBase
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVpnGatewayMember
     * @uses LVpnGatewayMember::setIssuerName()
     * @uses LVpnGatewayMember::setSerialNumber()
     * @uses LVpnGatewayMember::setUuid()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid);
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGatewayMember
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($issuerName) && mb_strlen($issuerName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGatewayMember
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($serialNumber) && mb_strlen($serialNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LVpnGatewayMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
