<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSyslogConfig StructType
 * @subpackage Structs
 */
class LSyslogConfig extends AbstractStructBase
{
    /**
     * The AlarmLevelEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmLevelEvent;
    /**
     * The RemoteServerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName;
    /**
     * The monitor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monitor;
    /**
     * The Enable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $Enable;
    /**
     * Constructor method for LSyslogConfig
     * @uses LSyslogConfig::setAlarmLevelEvent()
     * @uses LSyslogConfig::setRemoteServerName()
     * @uses LSyslogConfig::setMonitor()
     * @uses LSyslogConfig::setEnable()
     * @param string $alarmLevelEvent
     * @param string $remoteServerName
     * @param string $monitor
     * @param string $enable
     */
    public function __construct($alarmLevelEvent = null, $remoteServerName = null, $monitor = null, $enable = null)
    {
        $this
            ->setAlarmLevelEvent($alarmLevelEvent)
            ->setRemoteServerName($remoteServerName)
            ->setMonitor($monitor)
            ->setEnable($enable);
    }
    /**
     * Get AlarmLevelEvent value
     * @return string|null
     */
    public function getAlarmLevelEvent()
    {
        return $this->AlarmLevelEvent;
    }
    /**
     * Set AlarmLevelEvent value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAlarmSeverity::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAlarmSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmLevelEvent
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig
     */
    public function setAlarmLevelEvent($alarmLevelEvent = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAlarmSeverity::valueIsValid($alarmLevelEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAlarmSeverity', is_array($alarmLevelEvent) ? implode(', ', $alarmLevelEvent) : var_export($alarmLevelEvent, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAlarmSeverity::getValidValues())), __LINE__);
        }
        $this->AlarmLevelEvent = $alarmLevelEvent;
        return $this;
    }
    /**
     * Get RemoteServerName value
     * @return string|null
     */
    public function getRemoteServerName()
    {
        return $this->RemoteServerName;
    }
    /**
     * Set RemoteServerName value
     * @param string $remoteServerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig
     */
    public function setRemoteServerName($remoteServerName = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName) && !is_string($remoteServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteServerName, true), gettype($remoteServerName)), __LINE__);
        }
        $this->RemoteServerName = $remoteServerName;
        return $this;
    }
    /**
     * Get monitor value
     * @return string|null
     */
    public function getMonitor()
    {
        return $this->monitor;
    }
    /**
     * Set monitor value
     * @param string $monitor
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig
     */
    public function setMonitor($monitor = null)
    {
        // validation for constraint: string
        if (!is_null($monitor) && !is_string($monitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitor, true), gettype($monitor)), __LINE__);
        }
        $this->monitor = $monitor;
        return $this;
    }
    /**
     * Get Enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param string $enable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSyslogConfig
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enable, true), gettype($enable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enable, true)), __LINE__);
        }
        $this->Enable = $enable;
        return $this;
    }
}
