<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRoutePartition StructType
 * @subpackage Structs
 */
class LRoutePartition extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The timeScheduleIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - documentation: Only Applicable if TimeSchedule is selected. If OriginatingDevice is selected then this tag is not applicable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRoutePartition
     * @uses LRoutePartition::setName()
     * @uses LRoutePartition::setDescription()
     * @uses LRoutePartition::setDialPlanWizardGenId()
     * @uses LRoutePartition::setTimeScheduleIdName()
     * @uses LRoutePartition::setUseOriginatingDeviceTimeZone()
     * @uses LRoutePartition::setTimeZone()
     * @uses LRoutePartition::setPartitionUsage()
     * @uses LRoutePartition::setUuid()
     * @param string $name
     * @param string $description
     * @param string $dialPlanWizardGenId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     * @param string $partitionUsage
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $dialPlanWizardGenId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = null, $timeZone = null, $partitionUsage = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone)
            ->setPartitionUsage($partitionUsage)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardGenId) ? implode(', ', $dialPlanWizardGenId) : var_export($dialPlanWizardGenId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return $this->timeScheduleIdName;
    }
    /**
     * Set timeScheduleIdName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setTimeScheduleIdName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $timeScheduleIdName = null)
    {
        $this->timeScheduleIdName = $timeScheduleIdName;
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($useOriginatingDeviceTimeZone) && !is_string($useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useOriginatingDeviceTimeZone, true), gettype($useOriginatingDeviceTimeZone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useOriginatingDeviceTimeZone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useOriginatingDeviceTimeZone, true)), __LINE__);
        }
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRoutePartition
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
