<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteGroup StructType
 * @subpackage Structs
 */
class LRouteGroup extends AbstractStructBase
{
    /**
     * The dialPlanWizardGenld
     * Meta information extracted from the WSDL
     * - documentation: Read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenld;
    /**
     * The distributionAlgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteGroup
     * @uses LRouteGroup::setDialPlanWizardGenld()
     * @uses LRouteGroup::setDistributionAlgorithm()
     * @uses LRouteGroup::setName()
     * @uses LRouteGroup::setUuid()
     * @param string $dialPlanWizardGenld
     * @param string $distributionAlgorithm
     * @param string $name
     * @param string $uuid
     */
    public function __construct($dialPlanWizardGenld = null, $distributionAlgorithm = null, $name = null, $uuid = null)
    {
        $this
            ->setDialPlanWizardGenld($dialPlanWizardGenld)
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanWizardGenld value
     * @return string|null
     */
    public function getDialPlanWizardGenld()
    {
        return $this->dialPlanWizardGenld;
    }
    /**
     * Set dialPlanWizardGenld value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenld
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteGroup
     */
    public function setDialPlanWizardGenld($dialPlanWizardGenld = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardGenld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardGenld) ? implode(', ', $dialPlanWizardGenld) : var_export($dialPlanWizardGenld, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenld = $dialPlanWizardGenld;
        return $this;
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm', is_array($distributionAlgorithm) ? implode(', ', $distributionAlgorithm) : var_export($distributionAlgorithm, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRouteGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
