<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRegion StructType
 * @subpackage Structs
 */
class LRegion extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The defaultCodec
     * Meta information extracted from the WSDL
     * - documentation: Not valid for get and list
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultCodec;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRegion
     * @uses LRegion::setName()
     * @uses LRegion::setDefaultCodec()
     * @uses LRegion::setUuid()
     * @param string $name
     * @param string $defaultCodec
     * @param string $uuid
     */
    public function __construct($name = null, $defaultCodec = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDefaultCodec($defaultCodec)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegion
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get defaultCodec value
     * @return string|null
     */
    public function getDefaultCodec()
    {
        return $this->defaultCodec;
    }
    /**
     * Set defaultCodec value
     * @param string $defaultCodec
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegion
     */
    public function setDefaultCodec($defaultCodec = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCodec) && !is_string($defaultCodec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultCodec, true), gettype($defaultCodec)), __LINE__);
        }
        $this->defaultCodec = $defaultCodec;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LRegion
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
