<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMobileSmartClientProfile StructType
 * @subpackage Structs
 */
class LMobileSmartClientProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The mobileSmartClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobileSmartClient;
    /**
     * The enableSnrUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableSnrUri;
    /**
     * The enableCFAUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableCFAUri;
    /**
     * The handOffUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $handOffUri;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMobileSmartClientProfile
     * @uses LMobileSmartClientProfile::setName()
     * @uses LMobileSmartClientProfile::setMobileSmartClient()
     * @uses LMobileSmartClientProfile::setEnableSnrUri()
     * @uses LMobileSmartClientProfile::setEnableCFAUri()
     * @uses LMobileSmartClientProfile::setHandOffUri()
     * @uses LMobileSmartClientProfile::setUuid()
     * @param string $name
     * @param string $mobileSmartClient
     * @param string $enableSnrUri
     * @param string $enableCFAUri
     * @param string $handOffUri
     * @param string $uuid
     */
    public function __construct($name = null, $mobileSmartClient = null, $enableSnrUri = null, $enableCFAUri = null, $handOffUri = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setMobileSmartClient($mobileSmartClient)
            ->setEnableSnrUri($enableSnrUri)
            ->setEnableCFAUri($enableCFAUri)
            ->setHandOffUri($handOffUri)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get mobileSmartClient value
     * @return string|null
     */
    public function getMobileSmartClient()
    {
        return $this->mobileSmartClient;
    }
    /**
     * Set mobileSmartClient value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMobileSmartClient::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMobileSmartClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileSmartClient
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setMobileSmartClient($mobileSmartClient = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMobileSmartClient::valueIsValid($mobileSmartClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMobileSmartClient', is_array($mobileSmartClient) ? implode(', ', $mobileSmartClient) : var_export($mobileSmartClient, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMobileSmartClient::getValidValues())), __LINE__);
        }
        $this->mobileSmartClient = $mobileSmartClient;
        return $this;
    }
    /**
     * Get enableSnrUri value
     * @return string|null
     */
    public function getEnableSnrUri()
    {
        return $this->enableSnrUri;
    }
    /**
     * Set enableSnrUri value
     * @param string $enableSnrUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setEnableSnrUri($enableSnrUri = null)
    {
        // validation for constraint: string
        if (!is_null($enableSnrUri) && !is_string($enableSnrUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableSnrUri, true), gettype($enableSnrUri)), __LINE__);
        }
        $this->enableSnrUri = $enableSnrUri;
        return $this;
    }
    /**
     * Get enableCFAUri value
     * @return string|null
     */
    public function getEnableCFAUri()
    {
        return $this->enableCFAUri;
    }
    /**
     * Set enableCFAUri value
     * @param string $enableCFAUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setEnableCFAUri($enableCFAUri = null)
    {
        // validation for constraint: string
        if (!is_null($enableCFAUri) && !is_string($enableCFAUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCFAUri, true), gettype($enableCFAUri)), __LINE__);
        }
        $this->enableCFAUri = $enableCFAUri;
        return $this;
    }
    /**
     * Get handOffUri value
     * @return string|null
     */
    public function getHandOffUri()
    {
        return $this->handOffUri;
    }
    /**
     * Set handOffUri value
     * @param string $handOffUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setHandOffUri($handOffUri = null)
    {
        // validation for constraint: string
        if (!is_null($handOffUri) && !is_string($handOffUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handOffUri, true), gettype($handOffUri)), __LINE__);
        }
        $this->handOffUri = $handOffUri;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMobileSmartClientProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
