<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMediaResourceListMember StructType
 * @subpackage Structs
 */
class LMediaResourceListMember extends AbstractStructBase
{
    /**
     * The mediaResourceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceGroupName;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $order;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMediaResourceListMember
     * @uses LMediaResourceListMember::setMediaResourceGroupName()
     * @uses LMediaResourceListMember::setOrder()
     * @uses LMediaResourceListMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceGroupName
     * @param string $order
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceGroupName = null, $order = null, $uuid = null)
    {
        $this
            ->setMediaResourceGroupName($mediaResourceGroupName)
            ->setOrder($order)
            ->setUuid($uuid);
    }
    /**
     * Get mediaResourceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceGroupName()
    {
        return $this->mediaResourceGroupName;
    }
    /**
     * Set mediaResourceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMediaResourceListMember
     */
    public function setMediaResourceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceGroupName = null)
    {
        $this->mediaResourceGroupName = $mediaResourceGroupName;
        return $this;
    }
    /**
     * Get order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $order
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMediaResourceListMember
     */
    public function setOrder($order = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($order) ? implode(', ', $order) : var_export($order, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LMediaResourceListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
