<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLine StructType
 * @subpackage Structs
 */
class LLine extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The aarDestinationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarKeepCallHistory
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarKeepCallHistory;
    /**
     * The aarVoiceMailEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarVoiceMailEnabled;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta information extracted from the WSDL
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The hrDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrDuration;
    /**
     * The hrInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hrInterval;
    /**
     * The cfaCssPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonForwardNoRetrieveDn;
    /**
     * The parkMonForwardNoRetrieveIntDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonForwardNoRetrieveIntDn;
    /**
     * The parkMonForwardNoRetrieveVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveVmEnabled;
    /**
     * The parkMonForwardNoRetrieveIntVmEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveIntVmEnabled;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The parkMonReversionTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parkMonReversionTimer;
    /**
     * The partyEntranceTone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partyEntranceTone;
    /**
     * The allowCtiControlFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The rejectAnonymousCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousCall;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The externalCallControlProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControlProfile;
    /**
     * The enterpriseAltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum
     */
    public $enterpriseAltNum;
    /**
     * The e164AltNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum
     */
    public $e164AltNum;
    /**
     * The pstnFailover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailover;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLine
     * @uses LLine::setPattern()
     * @uses LLine::setDescription()
     * @uses LLine::setUsage()
     * @uses LLine::setRoutePartitionName()
     * @uses LLine::setAarNeighborhoodName()
     * @uses LLine::setAarDestinationMask()
     * @uses LLine::setAarKeepCallHistory()
     * @uses LLine::setAarVoiceMailEnabled()
     * @uses LLine::setCallPickupGroupName()
     * @uses LLine::setAutoAnswer()
     * @uses LLine::setNetworkHoldMohAudioSourceId()
     * @uses LLine::setUserHoldMohAudioSourceId()
     * @uses LLine::setAlertingName()
     * @uses LLine::setAsciiAlertingName()
     * @uses LLine::setPresenceGroupName()
     * @uses LLine::setShareLineAppearanceCssName()
     * @uses LLine::setVoiceMailProfileName()
     * @uses LLine::setPatternPrecedence()
     * @uses LLine::setReleaseClause()
     * @uses LLine::setHrDuration()
     * @uses LLine::setHrInterval()
     * @uses LLine::setCfaCssPolicy()
     * @uses LLine::setDefaultActivatedDeviceName()
     * @uses LLine::setParkMonForwardNoRetrieveDn()
     * @uses LLine::setParkMonForwardNoRetrieveIntDn()
     * @uses LLine::setParkMonForwardNoRetrieveVmEnabled()
     * @uses LLine::setParkMonForwardNoRetrieveIntVmEnabled()
     * @uses LLine::setParkMonForwardNoRetrieveCssName()
     * @uses LLine::setParkMonForwardNoRetrieveIntCssName()
     * @uses LLine::setParkMonReversionTimer()
     * @uses LLine::setPartyEntranceTone()
     * @uses LLine::setAllowCtiControlFlag()
     * @uses LLine::setRejectAnonymousCall()
     * @uses LLine::setConfidentialAccess()
     * @uses LLine::setExternalCallControlProfile()
     * @uses LLine::setEnterpriseAltNum()
     * @uses LLine::setE164AltNum()
     * @uses LLine::setPstnFailover()
     * @uses LLine::setAssociatedDevices()
     * @uses LLine::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $aarDestinationMask
     * @param string $aarKeepCallHistory
     * @param string $aarVoiceMailEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @param string $autoAnswer
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $hrDuration
     * @param string $hrInterval
     * @param string $cfaCssPolicy
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @param string $parkMonForwardNoRetrieveDn
     * @param string $parkMonForwardNoRetrieveIntDn
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @param string $parkMonReversionTimer
     * @param string $partyEntranceTone
     * @param string $allowCtiControlFlag
     * @param string $rejectAnonymousCall
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @param \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @param string $pstnFailover
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $aarDestinationMask = null, $aarKeepCallHistory = null, $aarVoiceMailEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null, $autoAnswer = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $alertingName = null, $asciiAlertingName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null, $patternPrecedence = null, $releaseClause = null, $hrDuration = null, $hrInterval = null, $cfaCssPolicy = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null, $parkMonForwardNoRetrieveDn = null, $parkMonForwardNoRetrieveIntDn = null, $parkMonForwardNoRetrieveVmEnabled = null, $parkMonForwardNoRetrieveIntVmEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null, $parkMonReversionTimer = null, $partyEntranceTone = null, $allowCtiControlFlag = null, $rejectAnonymousCall = null, \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null, \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null, $pstnFailover = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarKeepCallHistory($aarKeepCallHistory)
            ->setAarVoiceMailEnabled($aarVoiceMailEnabled)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setHrDuration($hrDuration)
            ->setHrInterval($hrInterval)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn)
            ->setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn)
            ->setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled)
            ->setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setParkMonReversionTimer($parkMonReversionTimer)
            ->setPartyEntranceTone($partyEntranceTone)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setRejectAnonymousCall($rejectAnonymousCall)
            ->setConfidentialAccess($confidentialAccess)
            ->setExternalCallControlProfile($externalCallControlProfile)
            ->setEnterpriseAltNum($enterpriseAltNum)
            ->setE164AltNum($e164AltNum)
            ->setPstnFailover($pstnFailover)
            ->setAssociatedDevices($associatedDevices)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return $this->aarDestinationMask;
    }
    /**
     * Set aarDestinationMask value
     * @param string $aarDestinationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarDestinationMask, true), gettype($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aarDestinationMask) && mb_strlen($aarDestinationMask) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aarDestinationMask)), __LINE__);
        }
        $this->aarDestinationMask = $aarDestinationMask;
        return $this;
    }
    /**
     * Get aarKeepCallHistory value
     * @return string|null
     */
    public function getAarKeepCallHistory()
    {
        return $this->aarKeepCallHistory;
    }
    /**
     * Set aarKeepCallHistory value
     * @param string $aarKeepCallHistory
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAarKeepCallHistory($aarKeepCallHistory = null)
    {
        // validation for constraint: string
        if (!is_null($aarKeepCallHistory) && !is_string($aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarKeepCallHistory, true), gettype($aarKeepCallHistory)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($aarKeepCallHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($aarKeepCallHistory, true)), __LINE__);
        }
        $this->aarKeepCallHistory = $aarKeepCallHistory;
        return $this;
    }
    /**
     * Get aarVoiceMailEnabled value
     * @return string|null
     */
    public function getAarVoiceMailEnabled()
    {
        return $this->aarVoiceMailEnabled;
    }
    /**
     * Set aarVoiceMailEnabled value
     * @param string $aarVoiceMailEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAarVoiceMailEnabled($aarVoiceMailEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($aarVoiceMailEnabled) && !is_string($aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aarVoiceMailEnabled, true), gettype($aarVoiceMailEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($aarVoiceMailEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($aarVoiceMailEnabled, true)), __LINE__);
        }
        $this->aarVoiceMailEnabled = $aarVoiceMailEnabled;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setCallPickupGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAutoAnswer($autoAnswer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer', is_array($autoAnswer) ? implode(', ', $autoAnswer) : var_export($autoAnswer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($networkHoldMohAudioSourceId) ? implode(', ', $networkHoldMohAudioSourceId) : var_export($networkHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($userHoldMohAudioSourceId) ? implode(', ', $userHoldMohAudioSourceId) : var_export($userHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alertingName, true), gettype($alertingName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($alertingName) && mb_strlen($alertingName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiAlertingName, true), gettype($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($asciiAlertingName) && mb_strlen($asciiAlertingName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return $this->shareLineAppearanceCssName;
    }
    /**
     * Set shareLineAppearanceCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setShareLineAppearanceCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $shareLineAppearanceCssName = null)
    {
        $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setVoiceMailProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue', is_array($releaseClause) ? implode(', ', $releaseClause) : var_export($releaseClause, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get hrDuration value
     * @return string|null
     */
    public function getHrDuration()
    {
        return $this->hrDuration;
    }
    /**
     * Set hrDuration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setHrDuration($hrDuration = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($hrDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($hrDuration) ? implode(', ', $hrDuration) : var_export($hrDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->hrDuration = $hrDuration;
        return $this;
    }
    /**
     * Get hrInterval value
     * @return string|null
     */
    public function getHrInterval()
    {
        return $this->hrInterval;
    }
    /**
     * Set hrInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setHrInterval($hrInterval = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($hrInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($hrInterval) ? implode(', ', $hrInterval) : var_export($hrInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->hrInterval = $hrInterval;
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return string|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cfaCssPolicy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setCfaCssPolicy($cfaCssPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::valueIsValid($cfaCssPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy', is_array($cfaCssPolicy) ? implode(', ', $cfaCssPolicy) : var_export($cfaCssPolicy, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return $this->defaultActivatedDeviceName;
    }
    /**
     * Set defaultActivatedDeviceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setDefaultActivatedDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultActivatedDeviceName = null)
    {
        $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveDn()
    {
        return $this->parkMonForwardNoRetrieveDn;
    }
    /**
     * Set parkMonForwardNoRetrieveDn value
     * @param string $parkMonForwardNoRetrieveDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveDn) && !is_string($parkMonForwardNoRetrieveDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveDn, true), gettype($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parkMonForwardNoRetrieveDn) && mb_strlen($parkMonForwardNoRetrieveDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveDn = $parkMonForwardNoRetrieveDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntDn value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntDn()
    {
        return $this->parkMonForwardNoRetrieveIntDn;
    }
    /**
     * Set parkMonForwardNoRetrieveIntDn value
     * @param string $parkMonForwardNoRetrieveIntDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntDn) && !is_string($parkMonForwardNoRetrieveIntDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveIntDn, true), gettype($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parkMonForwardNoRetrieveIntDn) && mb_strlen($parkMonForwardNoRetrieveIntDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntDn = $parkMonForwardNoRetrieveIntDn;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveVmEnabled value
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !is_string($parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveVmEnabled, true), gettype($parkMonForwardNoRetrieveVmEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($parkMonForwardNoRetrieveVmEnabled, true)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveVmEnabled = $parkMonForwardNoRetrieveVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveIntVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveIntVmEnabled value
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !is_string($parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parkMonForwardNoRetrieveIntVmEnabled, true), gettype($parkMonForwardNoRetrieveIntVmEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($parkMonForwardNoRetrieveIntVmEnabled, true)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntVmEnabled = $parkMonForwardNoRetrieveIntVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return $this->parkMonForwardNoRetrieveCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveCssName = null)
    {
        $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return $this->parkMonForwardNoRetrieveIntCssName;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonForwardNoRetrieveIntCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        return $this;
    }
    /**
     * Get parkMonReversionTimer value
     * @return string|null
     */
    public function getParkMonReversionTimer()
    {
        return $this->parkMonReversionTimer;
    }
    /**
     * Set parkMonReversionTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonReversionTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setParkMonReversionTimer($parkMonReversionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($parkMonReversionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($parkMonReversionTimer) ? implode(', ', $parkMonReversionTimer) : var_export($parkMonReversionTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->parkMonReversionTimer = $parkMonReversionTimer;
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setPartyEntranceTone($partyEntranceTone = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($partyEntranceTone) ? implode(', ', $partyEntranceTone) : var_export($partyEntranceTone, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowCtiControlFlag, true), gettype($allowCtiControlFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get rejectAnonymousCall value
     * @return string|null
     */
    public function getRejectAnonymousCall()
    {
        return $this->rejectAnonymousCall;
    }
    /**
     * Set rejectAnonymousCall value
     * @param string $rejectAnonymousCall
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setRejectAnonymousCall($rejectAnonymousCall = null)
    {
        // validation for constraint: string
        if (!is_null($rejectAnonymousCall) && !is_string($rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectAnonymousCall, true), gettype($rejectAnonymousCall)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rejectAnonymousCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rejectAnonymousCall, true)), __LINE__);
        }
        $this->rejectAnonymousCall = $rejectAnonymousCall;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setConfidentialAccess(\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get externalCallControlProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControlProfile()
    {
        return $this->externalCallControlProfile;
    }
    /**
     * Set externalCallControlProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setExternalCallControlProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControlProfile = null)
    {
        $this->externalCallControlProfile = $externalCallControlProfile;
        return $this;
    }
    /**
     * Get enterpriseAltNum value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum|null
     */
    public function getEnterpriseAltNum()
    {
        return $this->enterpriseAltNum;
    }
    /**
     * Set enterpriseAltNum value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setEnterpriseAltNum(\Losc\CucmBundle\Model\Webservice\StructType\EnterpriseAltNum $enterpriseAltNum = null)
    {
        $this->enterpriseAltNum = $enterpriseAltNum;
        return $this;
    }
    /**
     * Get e164AltNum value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum|null
     */
    public function getE164AltNum()
    {
        return $this->e164AltNum;
    }
    /**
     * Set e164AltNum value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setE164AltNum(\Losc\CucmBundle\Model\Webservice\StructType\E164AltNum $e164AltNum = null)
    {
        $this->e164AltNum = $e164AltNum;
        return $this;
    }
    /**
     * Get pstnFailover value
     * @return string|null
     */
    public function getPstnFailover()
    {
        return $this->pstnFailover;
    }
    /**
     * Set pstnFailover value
     * @param string $pstnFailover
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setPstnFailover($pstnFailover = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailover) && !is_string($pstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailover, true), gettype($pstnFailover)), __LINE__);
        }
        $this->pstnFailover = $pstnFailover;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setAssociatedDevices(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
