<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LIpPhoneServices StructType
 * @subpackage Structs
 */
class LIpPhoneServices extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceName;
    /**
     * The asciiServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceUrl;
    /**
     * The secureServiceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The serviceVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The enterpriseSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enterpriseSubscription;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LIpPhoneServices
     * @uses LIpPhoneServices::setServiceName()
     * @uses LIpPhoneServices::setAsciiServiceName()
     * @uses LIpPhoneServices::setServiceDescription()
     * @uses LIpPhoneServices::setServiceUrl()
     * @uses LIpPhoneServices::setSecureServiceUrl()
     * @uses LIpPhoneServices::setServiceCategory()
     * @uses LIpPhoneServices::setServiceType()
     * @uses LIpPhoneServices::setServiceVendor()
     * @uses LIpPhoneServices::setServiceVersion()
     * @uses LIpPhoneServices::setEnabled()
     * @uses LIpPhoneServices::setEnterpriseSubscription()
     * @uses LIpPhoneServices::setUuid()
     * @param string $serviceName
     * @param string $asciiServiceName
     * @param string $serviceDescription
     * @param string $serviceUrl
     * @param string $secureServiceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param string $enterpriseSubscription
     * @param string $uuid
     */
    public function __construct($serviceName = null, $asciiServiceName = null, $serviceDescription = null, $serviceUrl = null, $secureServiceUrl = null, $serviceCategory = null, $serviceType = null, $serviceVendor = null, $serviceVersion = null, $enabled = null, $enterpriseSubscription = null, $uuid = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceDescription($serviceDescription)
            ->setServiceUrl($serviceUrl)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setEnterpriseSubscription($enterpriseSubscription)
            ->setUuid($uuid);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceName) && mb_strlen($serviceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string|null
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiServiceName, true), gettype($asciiServiceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($asciiServiceName) && mb_strlen($asciiServiceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * @return string|null
     */
    public function getServiceDescription()
    {
        return $this->serviceDescription;
    }
    /**
     * Set serviceDescription value
     * @param string $serviceDescription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceDescription) && mb_strlen($serviceDescription) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceDescription)), __LINE__);
        }
        $this->serviceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Get serviceUrl value
     * @return string|null
     */
    public function getServiceUrl()
    {
        return $this->serviceUrl;
    }
    /**
     * Set serviceUrl value
     * @param string $serviceUrl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceUrl, true), gettype($serviceUrl)), __LINE__);
        }
        $this->serviceUrl = $serviceUrl;
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return $this->secureServiceUrl;
    }
    /**
     * Set secureServiceUrl value
     * @param string $secureServiceUrl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureServiceUrl, true), gettype($secureServiceUrl)), __LINE__);
        }
        $this->secureServiceUrl = $secureServiceUrl;
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceCategory($serviceCategory = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory', is_array($serviceCategory) ? implode(', ', $serviceCategory) : var_export($serviceCategory, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVendor, true), gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVersion, true), gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enabled, true)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get enterpriseSubscription value
     * @return string|null
     */
    public function getEnterpriseSubscription()
    {
        return $this->enterpriseSubscription;
    }
    /**
     * Set enterpriseSubscription value
     * @param string $enterpriseSubscription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setEnterpriseSubscription($enterpriseSubscription = null)
    {
        // validation for constraint: string
        if (!is_null($enterpriseSubscription) && !is_string($enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enterpriseSubscription, true), gettype($enterpriseSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enterpriseSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enterpriseSubscription, true)), __LINE__);
        }
        $this->enterpriseSubscription = $enterpriseSubscription;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LIpPhoneServices
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
