<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LHuntPilot StructType
 * @subpackage Structs
 */
class LHuntPilot extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The huntListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $huntListName;
    /**
     * The parkMonForwardNoRetrieve
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve
     */
    public $parkMonForwardNoRetrieve;
    /**
     * The alertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The forwardHuntNoAnswer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer
     */
    public $forwardHuntNoAnswer;
    /**
     * The forwardHuntBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy
     */
    public $forwardHuntBusy;
    /**
     * The callPickupGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The maxHuntduration
     * Meta information extracted from the WSDL
     * - documentation: Value "-1" in the response means no value has been assigned and internally the CM will use default setting i.e., 1800s.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxHuntduration;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The displayConnectedNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayConnectedNumber;
    /**
     * The queueCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public $queueCalls;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LHuntPilot
     * @uses LHuntPilot::setPattern()
     * @uses LHuntPilot::setDescription()
     * @uses LHuntPilot::setUsage()
     * @uses LHuntPilot::setRoutePartitionName()
     * @uses LHuntPilot::setBlockEnable()
     * @uses LHuntPilot::setCalledPartyTransformationMask()
     * @uses LHuntPilot::setCallingPartyTransformationMask()
     * @uses LHuntPilot::setUseCallingPartyPhoneMask()
     * @uses LHuntPilot::setCallingPartyPrefixDigits()
     * @uses LHuntPilot::setDialPlanName()
     * @uses LHuntPilot::setDigitDiscardInstructionName()
     * @uses LHuntPilot::setPatternUrgency()
     * @uses LHuntPilot::setPrefixDigitsOut()
     * @uses LHuntPilot::setRouteFilterName()
     * @uses LHuntPilot::setCallingLinePresentationBit()
     * @uses LHuntPilot::setCallingNamePresentationBit()
     * @uses LHuntPilot::setConnectedLinePresentationBit()
     * @uses LHuntPilot::setConnectedNamePresentationBit()
     * @uses LHuntPilot::setPatternPrecedence()
     * @uses LHuntPilot::setProvideOutsideDialtone()
     * @uses LHuntPilot::setCallingPartyNumberingPlan()
     * @uses LHuntPilot::setCallingPartyNumberType()
     * @uses LHuntPilot::setCalledPartyNumberingPlan()
     * @uses LHuntPilot::setCalledPartyNumberType()
     * @uses LHuntPilot::setHuntListName()
     * @uses LHuntPilot::setParkMonForwardNoRetrieve()
     * @uses LHuntPilot::setAlertingName()
     * @uses LHuntPilot::setAsciiAlertingName()
     * @uses LHuntPilot::setAarNeighborhoodName()
     * @uses LHuntPilot::setForwardHuntNoAnswer()
     * @uses LHuntPilot::setForwardHuntBusy()
     * @uses LHuntPilot::setCallPickupGroupName()
     * @uses LHuntPilot::setMaxHuntduration()
     * @uses LHuntPilot::setReleaseClause()
     * @uses LHuntPilot::setDisplayConnectedNumber()
     * @uses LHuntPilot::setQueueCalls()
     * @uses LHuntPilot::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $patternPrecedence
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @param string $maxHuntduration
     * @param string $releaseClause
     * @param string $displayConnectedNumber
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue $queueCalls
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $prefixDigitsOut = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $patternPrecedence = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName = null, \Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null, $alertingName = null, $asciiAlertingName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null, \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null, $maxHuntduration = null, $releaseClause = null, $displayConnectedNumber = null, \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue $queueCalls = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setHuntListName($huntListName)
            ->setParkMonForwardNoRetrieve($parkMonForwardNoRetrieve)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setForwardHuntNoAnswer($forwardHuntNoAnswer)
            ->setForwardHuntBusy($forwardHuntBusy)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setMaxHuntduration($maxHuntduration)
            ->setReleaseClause($releaseClause)
            ->setDisplayConnectedNumber($displayConnectedNumber)
            ->setQueueCalls($queueCalls)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockEnable, true), gettype($blockEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($blockEnable, true)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useCallingPartyPhoneMask) ? implode(', ', $useCallingPartyPhoneMask) : var_export($useCallingPartyPhoneMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patternUrgency, true), gettype($patternUrgency)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($patternUrgency, true)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLinePresentationBit) ? implode(', ', $callingLinePresentationBit) : var_export($callingLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingNamePresentationBit) ? implode(', ', $callingNamePresentationBit) : var_export($callingNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedLinePresentationBit) ? implode(', ', $connectedLinePresentationBit) : var_export($connectedLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedNamePresentationBit) ? implode(', ', $connectedNamePresentationBit) : var_export($connectedNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provideOutsideDialtone, true), gettype($provideOutsideDialtone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get huntListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getHuntListName()
    {
        return $this->huntListName;
    }
    /**
     * Set huntListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setHuntListName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $huntListName = null)
    {
        $this->huntListName = $huntListName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieve value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve|null
     */
    public function getParkMonForwardNoRetrieve()
    {
        return $this->parkMonForwardNoRetrieve;
    }
    /**
     * Set parkMonForwardNoRetrieve value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setParkMonForwardNoRetrieve(\Losc\CucmBundle\Model\Webservice\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null)
    {
        $this->parkMonForwardNoRetrieve = $parkMonForwardNoRetrieve;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alertingName, true), gettype($alertingName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($alertingName) && mb_strlen($alertingName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiAlertingName, true), gettype($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($asciiAlertingName) && mb_strlen($asciiAlertingName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get forwardHuntNoAnswer value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer|null
     */
    public function getForwardHuntNoAnswer()
    {
        return $this->forwardHuntNoAnswer;
    }
    /**
     * Set forwardHuntNoAnswer value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setForwardHuntNoAnswer(\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null)
    {
        $this->forwardHuntNoAnswer = $forwardHuntNoAnswer;
        return $this;
    }
    /**
     * Get forwardHuntBusy value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy|null
     */
    public function getForwardHuntBusy()
    {
        return $this->forwardHuntBusy;
    }
    /**
     * Set forwardHuntBusy value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setForwardHuntBusy(\Losc\CucmBundle\Model\Webservice\StructType\ForwardHuntBusy $forwardHuntBusy = null)
    {
        $this->forwardHuntBusy = $forwardHuntBusy;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setCallPickupGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get maxHuntduration value
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return $this->maxHuntduration;
    }
    /**
     * Set maxHuntduration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHuntduration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxHuntduration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxHuntduration) ? implode(', ', $maxHuntduration) : var_export($maxHuntduration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxHuntduration = $maxHuntduration;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue', is_array($releaseClause) ? implode(', ', $releaseClause) : var_export($releaseClause, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get displayConnectedNumber value
     * @return string|null
     */
    public function getDisplayConnectedNumber()
    {
        return $this->displayConnectedNumber;
    }
    /**
     * Set displayConnectedNumber value
     * @param string $displayConnectedNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setDisplayConnectedNumber($displayConnectedNumber = null)
    {
        // validation for constraint: string
        if (!is_null($displayConnectedNumber) && !is_string($displayConnectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayConnectedNumber, true), gettype($displayConnectedNumber)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($displayConnectedNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayConnectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($displayConnectedNumber, true)), __LINE__);
        }
        $this->displayConnectedNumber = $displayConnectedNumber;
        return $this;
    }
    /**
     * Get queueCalls value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue|null
     */
    public function getQueueCalls()
    {
        return $this->queueCalls;
    }
    /**
     * Set queueCalls value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue $queueCalls
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setQueueCalls(\Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue $queueCalls = null)
    {
        $this->queueCalls = $queueCalls;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LHuntPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
