<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LH323Phone StructType
 * @subpackage Structs
 */
class LH323Phone extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The remoteDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferredCodec
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferredCodec;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The displayIEDelivery
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIEDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The hlogStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The signalingPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signalingPort;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LH323Phone
     * @uses LH323Phone::setName()
     * @uses LH323Phone::setDescription()
     * @uses LH323Phone::setProduct()
     * @uses LH323Phone::setModel()
     * @uses LH323Phone::setClass()
     * @uses LH323Phone::setProtocol()
     * @uses LH323Phone::setProtocolSide()
     * @uses LH323Phone::setCallingSearchSpaceName()
     * @uses LH323Phone::setDevicePoolName()
     * @uses LH323Phone::setCommonDeviceConfigName()
     * @uses LH323Phone::setCommonPhoneConfigName()
     * @uses LH323Phone::setLocationName()
     * @uses LH323Phone::setMediaResourceListName()
     * @uses LH323Phone::setAutomatedAlternateRoutingCssName()
     * @uses LH323Phone::setAarNeighborhoodName()
     * @uses LH323Phone::setTraceFlag()
     * @uses LH323Phone::setUseTrustedRelayPoint()
     * @uses LH323Phone::setRetryVideoCallAsAudio()
     * @uses LH323Phone::setRemoteDevice()
     * @uses LH323Phone::setCgpnTransformationCssName()
     * @uses LH323Phone::setUseDevicePoolCgpnTransformCss()
     * @uses LH323Phone::setGeoLocationName()
     * @uses LH323Phone::setAlwaysUsePrimeLine()
     * @uses LH323Phone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LH323Phone::setSrtpAllowed()
     * @uses LH323Phone::setUnattendedPort()
     * @uses LH323Phone::setSubscribeCallingSearchSpaceName()
     * @uses LH323Phone::setMtpRequired()
     * @uses LH323Phone::setMtpPreferredCodec()
     * @uses LH323Phone::setCallerIdDn()
     * @uses LH323Phone::setCallingPartySelection()
     * @uses LH323Phone::setCallingLineIdPresentation()
     * @uses LH323Phone::setDisplayIEDelivery()
     * @uses LH323Phone::setRedirectOutboundNumberIe()
     * @uses LH323Phone::setRedirectInboundNumberIe()
     * @uses LH323Phone::setPresenceGroupName()
     * @uses LH323Phone::setHlogStatus()
     * @uses LH323Phone::setOwnerUserName()
     * @uses LH323Phone::setSignalingPort()
     * @uses LH323Phone::setIgnorePresentationIndicators()
     * @uses LH323Phone::setCtiid()
     * @uses LH323Phone::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $traceFlag
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param string $remoteDevice
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $srtpAllowed
     * @param string $unattendedPort
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $mtpRequired
     * @param string $mtpPreferredCodec
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $displayIEDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $hlogStatus
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @param string $signalingPort
     * @param string $ignorePresentationIndicators
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $traceFlag = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, $remoteDevice = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, $srtpAllowed = null, $unattendedPort = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, $mtpRequired = null, $mtpPreferredCodec = null, $callerIdDn = null, $callingPartySelection = null, $callingLineIdPresentation = null, $displayIEDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $hlogStatus = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null, $signalingPort = null, $ignorePresentationIndicators = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setTraceFlag($traceFlag)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRemoteDevice($remoteDevice)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSrtpAllowed($srtpAllowed)
            ->setUnattendedPort($unattendedPort)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferredCodec($mtpPreferredCodec)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setDisplayIEDelivery($displayIEDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setPresenceGroupName($presenceGroupName)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setSignalingPort($signalingPort)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCommonPhoneConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setMediaResourceListName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setAutomatedAlternateRoutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setAarNeighborhoodName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteDevice, true), gettype($remoteDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($remoteDevice, true)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCgpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setGeoLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLine) ? implode(', ', $alwaysUsePrimeLine) : var_export($alwaysUsePrimeLine, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLineForVoiceMessage) ? implode(', ', $alwaysUsePrimeLineForVoiceMessage) : var_export($alwaysUsePrimeLineForVoiceMessage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpAllowed, true), gettype($srtpAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpAllowed, true)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setSubscribeCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mtpRequired, true), gettype($mtpRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mtpRequired, true)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferredCodec value
     * @return string|null
     */
    public function getMtpPreferredCodec()
    {
        return $this->mtpPreferredCodec;
    }
    /**
     * Set mtpPreferredCodec value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferredCodec
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setMtpPreferredCodec($mtpPreferredCodec = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::valueIsValid($mtpPreferredCodec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec', is_array($mtpPreferredCodec) ? implode(', ', $mtpPreferredCodec) : var_export($mtpPreferredCodec, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferredCodec = $mtpPreferredCodec;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLineIdPresentation) ? implode(', ', $callingLineIdPresentation) : var_export($callingLineIdPresentation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get displayIEDelivery value
     * @return string|null
     */
    public function getDisplayIEDelivery()
    {
        return $this->displayIEDelivery;
    }
    /**
     * Set displayIEDelivery value
     * @param string $displayIEDelivery
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setDisplayIEDelivery($displayIEDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($displayIEDelivery) && !is_string($displayIEDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayIEDelivery, true), gettype($displayIEDelivery)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($displayIEDelivery) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayIEDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($displayIEDelivery, true)), __LINE__);
        }
        $this->displayIEDelivery = $displayIEDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectOutboundNumberIe, true), gettype($redirectOutboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectInboundNumberIe, true), gettype($redirectInboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @param string $hlogStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        // validation for constraint: string
        if (!is_null($hlogStatus) && !is_string($hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hlogStatus, true), gettype($hlogStatus)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($hlogStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($hlogStatus, true)), __LINE__);
        }
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setOwnerUserName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string|null
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $signalingPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setSignalingPort($signalingPort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($signalingPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($signalingPort) ? implode(', ', $signalingPort) : var_export($signalingPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignorePresentationIndicators, true), gettype($ignorePresentationIndicators)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LH323Phone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
