<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LExternalCallControlProfile StructType
 * @subpackage Structs
 */
class LExternalCallControlProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The primaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryUri;
    /**
     * The secondaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryUri;
    /**
     * The enableLoadBalancing
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableLoadBalancing;
    /**
     * The routingRequestTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routingRequestTimer;
    /**
     * The diversionReroutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $diversionReroutingCssName;
    /**
     * The callTreatmentOnFailure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callTreatmentOnFailure;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LExternalCallControlProfile
     * @uses LExternalCallControlProfile::setName()
     * @uses LExternalCallControlProfile::setPrimaryUri()
     * @uses LExternalCallControlProfile::setSecondaryUri()
     * @uses LExternalCallControlProfile::setEnableLoadBalancing()
     * @uses LExternalCallControlProfile::setRoutingRequestTimer()
     * @uses LExternalCallControlProfile::setDiversionReroutingCssName()
     * @uses LExternalCallControlProfile::setCallTreatmentOnFailure()
     * @uses LExternalCallControlProfile::setUuid()
     * @param string $name
     * @param string $primaryUri
     * @param string $secondaryUri
     * @param string $enableLoadBalancing
     * @param string $routingRequestTimer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     * @param string $callTreatmentOnFailure
     * @param string $uuid
     */
    public function __construct($name = null, $primaryUri = null, $secondaryUri = null, $enableLoadBalancing = null, $routingRequestTimer = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null, $callTreatmentOnFailure = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setPrimaryUri($primaryUri)
            ->setSecondaryUri($secondaryUri)
            ->setEnableLoadBalancing($enableLoadBalancing)
            ->setRoutingRequestTimer($routingRequestTimer)
            ->setDiversionReroutingCssName($diversionReroutingCssName)
            ->setCallTreatmentOnFailure($callTreatmentOnFailure)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get primaryUri value
     * @return string|null
     */
    public function getPrimaryUri()
    {
        return $this->primaryUri;
    }
    /**
     * Set primaryUri value
     * @param string $primaryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setPrimaryUri($primaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($primaryUri) && !is_string($primaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryUri, true), gettype($primaryUri)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($primaryUri) && mb_strlen($primaryUri) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($primaryUri)), __LINE__);
        }
        $this->primaryUri = $primaryUri;
        return $this;
    }
    /**
     * Get secondaryUri value
     * @return string|null
     */
    public function getSecondaryUri()
    {
        return $this->secondaryUri;
    }
    /**
     * Set secondaryUri value
     * @param string $secondaryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setSecondaryUri($secondaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryUri) && !is_string($secondaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryUri, true), gettype($secondaryUri)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($secondaryUri) && mb_strlen($secondaryUri) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($secondaryUri)), __LINE__);
        }
        $this->secondaryUri = $secondaryUri;
        return $this;
    }
    /**
     * Get enableLoadBalancing value
     * @return string|null
     */
    public function getEnableLoadBalancing()
    {
        return $this->enableLoadBalancing;
    }
    /**
     * Set enableLoadBalancing value
     * @param string $enableLoadBalancing
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setEnableLoadBalancing($enableLoadBalancing = null)
    {
        // validation for constraint: string
        if (!is_null($enableLoadBalancing) && !is_string($enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableLoadBalancing, true), gettype($enableLoadBalancing)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableLoadBalancing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableLoadBalancing, true)), __LINE__);
        }
        $this->enableLoadBalancing = $enableLoadBalancing;
        return $this;
    }
    /**
     * Get routingRequestTimer value
     * @return string|null
     */
    public function getRoutingRequestTimer()
    {
        return $this->routingRequestTimer;
    }
    /**
     * Set routingRequestTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routingRequestTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setRoutingRequestTimer($routingRequestTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($routingRequestTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($routingRequestTimer) ? implode(', ', $routingRequestTimer) : var_export($routingRequestTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->routingRequestTimer = $routingRequestTimer;
        return $this;
    }
    /**
     * Get diversionReroutingCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDiversionReroutingCssName()
    {
        return $this->diversionReroutingCssName;
    }
    /**
     * Set diversionReroutingCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setDiversionReroutingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null)
    {
        $this->diversionReroutingCssName = $diversionReroutingCssName;
        return $this;
    }
    /**
     * Get callTreatmentOnFailure value
     * @return string|null
     */
    public function getCallTreatmentOnFailure()
    {
        return $this->callTreatmentOnFailure;
    }
    /**
     * Set callTreatmentOnFailure value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callTreatmentOnFailure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setCallTreatmentOnFailure($callTreatmentOnFailure = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::valueIsValid($callTreatmentOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure', is_array($callTreatmentOnFailure) ? implode(', ', $callTreatmentOnFailure) : var_export($callTreatmentOnFailure, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallTreatmentOnFailure::getValidValues())), __LINE__);
        }
        $this->callTreatmentOnFailure = $callTreatmentOnFailure;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LExternalCallControlProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
