<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDirectedCallPark StructType
 * @subpackage Structs
 */
class LDirectedCallPark extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The retrievalPrefix
     * Meta information extracted from the WSDL
     * - documentation: The prefix used for park-code retrieval. User will dial prefix plus park code to retrieve a parked call.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retrievalPrefix;
    /**
     * The reversionPattern
     * Meta information extracted from the WSDL
     * - documentation: The pattern used to revert the call when the parked call is not retrieved within retrieval timer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reversionPattern;
    /**
     * The revertCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $revertCssName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDirectedCallPark
     * @uses LDirectedCallPark::setPattern()
     * @uses LDirectedCallPark::setDescription()
     * @uses LDirectedCallPark::setUsage()
     * @uses LDirectedCallPark::setRoutePartitionName()
     * @uses LDirectedCallPark::setRetrievalPrefix()
     * @uses LDirectedCallPark::setReversionPattern()
     * @uses LDirectedCallPark::setRevertCssName()
     * @uses LDirectedCallPark::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $retrievalPrefix
     * @param string $reversionPattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $retrievalPrefix = null, $reversionPattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setRetrievalPrefix($retrievalPrefix)
            ->setReversionPattern($reversionPattern)
            ->setRevertCssName($revertCssName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get retrievalPrefix value
     * @return string|null
     */
    public function getRetrievalPrefix()
    {
        return $this->retrievalPrefix;
    }
    /**
     * Set retrievalPrefix value
     * @param string $retrievalPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setRetrievalPrefix($retrievalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalPrefix) && !is_string($retrievalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrievalPrefix, true), gettype($retrievalPrefix)), __LINE__);
        }
        $this->retrievalPrefix = $retrievalPrefix;
        return $this;
    }
    /**
     * Get reversionPattern value
     * @return string|null
     */
    public function getReversionPattern()
    {
        return $this->reversionPattern;
    }
    /**
     * Set reversionPattern value
     * @param string $reversionPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setReversionPattern($reversionPattern = null)
    {
        // validation for constraint: string
        if (!is_null($reversionPattern) && !is_string($reversionPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reversionPattern, true), gettype($reversionPattern)), __LINE__);
        }
        $this->reversionPattern = $reversionPattern;
        return $this;
    }
    /**
     * Get revertCssName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRevertCssName()
    {
        return $this->revertCssName;
    }
    /**
     * Set revertCssName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setRevertCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName = null)
    {
        $this->revertCssName = $revertCssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDirectedCallPark
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
