<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDevicePoolDeviceMobility StructType
 * @subpackage Structs
 */
class LDevicePoolDeviceMobility extends AbstractStructBase
{
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDevicePoolDeviceMobility
     * @uses LDevicePoolDeviceMobility::setDevicePoolName()
     * @uses LDevicePoolDeviceMobility::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, $uuid = null)
    {
        $this
            ->setDevicePoolName($devicePoolName)
            ->setUuid($uuid);
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDevicePoolDeviceMobility
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LDevicePoolDeviceMobility
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
