<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCommonPhoneConfig StructType
 * @subpackage Structs
 */
class LCommonPhoneConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndAlertingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndAlertingType;
    /**
     * The backgroundImage
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $backgroundImage;
    /**
     * The phonePersonalization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phonePersonalization;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The sshUserId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sshUserId;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The vpnGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnGroupName;
    /**
     * The vpnProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnProfileName;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCommonPhoneConfig
     * @uses LCommonPhoneConfig::setName()
     * @uses LCommonPhoneConfig::setDescription()
     * @uses LCommonPhoneConfig::setDndOption()
     * @uses LCommonPhoneConfig::setDndAlertingType()
     * @uses LCommonPhoneConfig::setBackgroundImage()
     * @uses LCommonPhoneConfig::setPhonePersonalization()
     * @uses LCommonPhoneConfig::setPhoneServiceDisplay()
     * @uses LCommonPhoneConfig::setSshUserId()
     * @uses LCommonPhoneConfig::setAlwaysUsePrimeLine()
     * @uses LCommonPhoneConfig::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LCommonPhoneConfig::setVpnGroupName()
     * @uses LCommonPhoneConfig::setVpnProfileName()
     * @uses LCommonPhoneConfig::setFeatureControlPolicy()
     * @uses LCommonPhoneConfig::setUuid()
     * @param string $name
     * @param string $description
     * @param string $dndOption
     * @param string $dndAlertingType
     * @param string $backgroundImage
     * @param string $phonePersonalization
     * @param string $phoneServiceDisplay
     * @param string $sshUserId
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $dndOption = null, $dndAlertingType = null, $backgroundImage = null, $phonePersonalization = null, $phoneServiceDisplay = null, $sshUserId = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDndOption($dndOption)
            ->setDndAlertingType($dndAlertingType)
            ->setBackgroundImage($backgroundImage)
            ->setPhonePersonalization($phonePersonalization)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setSshUserId($sshUserId)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setVpnGroupName($vpnGroupName)
            ->setVpnProfileName($vpnProfileName)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption', is_array($dndOption) ? implode(', ', $dndOption) : var_export($dndOption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndAlertingType value
     * @return string|null
     */
    public function getDndAlertingType()
    {
        return $this->dndAlertingType;
    }
    /**
     * Set dndAlertingType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndAlertingType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setDndAlertingType($dndAlertingType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($dndAlertingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($dndAlertingType) ? implode(', ', $dndAlertingType) : var_export($dndAlertingType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndAlertingType = $dndAlertingType;
        return $this;
    }
    /**
     * Get backgroundImage value
     * @return string|null
     */
    public function getBackgroundImage()
    {
        return $this->backgroundImage;
    }
    /**
     * Set backgroundImage value
     * @param string $backgroundImage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setBackgroundImage($backgroundImage = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundImage) && !is_string($backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundImage, true), gettype($backgroundImage)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($backgroundImage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($backgroundImage, true)), __LINE__);
        }
        $this->backgroundImage = $backgroundImage;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setPhonePersonalization($phonePersonalization = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization', is_array($phonePersonalization) ? implode(', ', $phonePersonalization) : var_export($phonePersonalization, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay', is_array($phoneServiceDisplay) ? implode(', ', $phoneServiceDisplay) : var_export($phoneServiceDisplay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sshUserId, true), gettype($sshUserId)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sshUserId) && mb_strlen($sshUserId) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLine) ? implode(', ', $alwaysUsePrimeLine) : var_export($alwaysUsePrimeLine, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLineForVoiceMessage) ? implode(', ', $alwaysUsePrimeLineForVoiceMessage) : var_export($alwaysUsePrimeLineForVoiceMessage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get vpnGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnGroupName()
    {
        return $this->vpnGroupName;
    }
    /**
     * Set vpnGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setVpnGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null)
    {
        $this->vpnGroupName = $vpnGroupName;
        return $this;
    }
    /**
     * Get vpnProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnProfileName()
    {
        return $this->vpnProfileName;
    }
    /**
     * Set vpnProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setVpnProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null)
    {
        $this->vpnProfileName = $vpnProfileName;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setFeatureControlPolicy(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCommonPhoneConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
