<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCcdRequestingServiceMember StructType
 * @subpackage Structs
 */
class LCcdRequestingServiceMember extends AbstractStructBase
{
    /**
     * The trunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $trunkName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCcdRequestingServiceMember
     * @uses LCcdRequestingServiceMember::setTrunkName()
     * @uses LCcdRequestingServiceMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $trunkName
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $trunkName = null, $uuid = null)
    {
        $this
            ->setTrunkName($trunkName)
            ->setUuid($uuid);
    }
    /**
     * Get trunkName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTrunkName()
    {
        return $this->trunkName;
    }
    /**
     * Set trunkName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $trunkName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCcdRequestingServiceMember
     */
    public function setTrunkName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $trunkName = null)
    {
        $this->trunkName = $trunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCcdRequestingServiceMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
