<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallsQueue StructType
 * @subpackage Structs
 */
class LCallsQueue extends AbstractStructBase
{
    /**
     * The maxCallersInQueue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxCallersInQueue;
    /**
     * The queueFullDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $queueFullDestination;
    /**
     * The callingSearchSpacePilotQueueFull
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpacePilotQueueFull;
    /**
     * The maxWaitTimeInQueue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxWaitTimeInQueue;
    /**
     * The maxWaitTimeDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxWaitTimeDestination;
    /**
     * The callingSearchSpaceMaxWaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceMaxWaitTime;
    /**
     * The noAgentDestination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $noAgentDestination;
    /**
     * The callingSearchSpaceNoAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceNoAgent;
    /**
     * The networkHoldMohAudioSourceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceID;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCallsQueue
     * @uses LCallsQueue::setMaxCallersInQueue()
     * @uses LCallsQueue::setQueueFullDestination()
     * @uses LCallsQueue::setCallingSearchSpacePilotQueueFull()
     * @uses LCallsQueue::setMaxWaitTimeInQueue()
     * @uses LCallsQueue::setMaxWaitTimeDestination()
     * @uses LCallsQueue::setCallingSearchSpaceMaxWaitTime()
     * @uses LCallsQueue::setNoAgentDestination()
     * @uses LCallsQueue::setCallingSearchSpaceNoAgent()
     * @uses LCallsQueue::setNetworkHoldMohAudioSourceID()
     * @uses LCallsQueue::setUuid()
     * @param string $maxCallersInQueue
     * @param string $queueFullDestination
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull
     * @param string $maxWaitTimeInQueue
     * @param string $maxWaitTimeDestination
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime
     * @param string $noAgentDestination
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent
     * @param string $networkHoldMohAudioSourceID
     * @param string $uuid
     */
    public function __construct($maxCallersInQueue = null, $queueFullDestination = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull = null, $maxWaitTimeInQueue = null, $maxWaitTimeDestination = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime = null, $noAgentDestination = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent = null, $networkHoldMohAudioSourceID = null, $uuid = null)
    {
        $this
            ->setMaxCallersInQueue($maxCallersInQueue)
            ->setQueueFullDestination($queueFullDestination)
            ->setCallingSearchSpacePilotQueueFull($callingSearchSpacePilotQueueFull)
            ->setMaxWaitTimeInQueue($maxWaitTimeInQueue)
            ->setMaxWaitTimeDestination($maxWaitTimeDestination)
            ->setCallingSearchSpaceMaxWaitTime($callingSearchSpaceMaxWaitTime)
            ->setNoAgentDestination($noAgentDestination)
            ->setCallingSearchSpaceNoAgent($callingSearchSpaceNoAgent)
            ->setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID)
            ->setUuid($uuid);
    }
    /**
     * Get maxCallersInQueue value
     * @return string|null
     */
    public function getMaxCallersInQueue()
    {
        return $this->maxCallersInQueue;
    }
    /**
     * Set maxCallersInQueue value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxCallersInQueue
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setMaxCallersInQueue($maxCallersInQueue = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxCallersInQueue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxCallersInQueue) ? implode(', ', $maxCallersInQueue) : var_export($maxCallersInQueue, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxCallersInQueue = $maxCallersInQueue;
        return $this;
    }
    /**
     * Get queueFullDestination value
     * @return string|null
     */
    public function getQueueFullDestination()
    {
        return $this->queueFullDestination;
    }
    /**
     * Set queueFullDestination value
     * @param string $queueFullDestination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setQueueFullDestination($queueFullDestination = null)
    {
        // validation for constraint: string
        if (!is_null($queueFullDestination) && !is_string($queueFullDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueFullDestination, true), gettype($queueFullDestination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($queueFullDestination) && mb_strlen($queueFullDestination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($queueFullDestination)), __LINE__);
        }
        $this->queueFullDestination = $queueFullDestination;
        return $this;
    }
    /**
     * Get callingSearchSpacePilotQueueFull value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpacePilotQueueFull()
    {
        return $this->callingSearchSpacePilotQueueFull;
    }
    /**
     * Set callingSearchSpacePilotQueueFull value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setCallingSearchSpacePilotQueueFull(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpacePilotQueueFull = null)
    {
        $this->callingSearchSpacePilotQueueFull = $callingSearchSpacePilotQueueFull;
        return $this;
    }
    /**
     * Get maxWaitTimeInQueue value
     * @return string|null
     */
    public function getMaxWaitTimeInQueue()
    {
        return $this->maxWaitTimeInQueue;
    }
    /**
     * Set maxWaitTimeInQueue value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeInQueue
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setMaxWaitTimeInQueue($maxWaitTimeInQueue = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxWaitTimeInQueue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxWaitTimeInQueue) ? implode(', ', $maxWaitTimeInQueue) : var_export($maxWaitTimeInQueue, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeInQueue = $maxWaitTimeInQueue;
        return $this;
    }
    /**
     * Get maxWaitTimeDestination value
     * @return string|null
     */
    public function getMaxWaitTimeDestination()
    {
        return $this->maxWaitTimeDestination;
    }
    /**
     * Set maxWaitTimeDestination value
     * @param string $maxWaitTimeDestination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setMaxWaitTimeDestination($maxWaitTimeDestination = null)
    {
        // validation for constraint: string
        if (!is_null($maxWaitTimeDestination) && !is_string($maxWaitTimeDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxWaitTimeDestination, true), gettype($maxWaitTimeDestination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($maxWaitTimeDestination) && mb_strlen($maxWaitTimeDestination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($maxWaitTimeDestination)), __LINE__);
        }
        $this->maxWaitTimeDestination = $maxWaitTimeDestination;
        return $this;
    }
    /**
     * Get callingSearchSpaceMaxWaitTime value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceMaxWaitTime()
    {
        return $this->callingSearchSpaceMaxWaitTime;
    }
    /**
     * Set callingSearchSpaceMaxWaitTime value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setCallingSearchSpaceMaxWaitTime(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceMaxWaitTime = null)
    {
        $this->callingSearchSpaceMaxWaitTime = $callingSearchSpaceMaxWaitTime;
        return $this;
    }
    /**
     * Get noAgentDestination value
     * @return string|null
     */
    public function getNoAgentDestination()
    {
        return $this->noAgentDestination;
    }
    /**
     * Set noAgentDestination value
     * @param string $noAgentDestination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setNoAgentDestination($noAgentDestination = null)
    {
        // validation for constraint: string
        if (!is_null($noAgentDestination) && !is_string($noAgentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noAgentDestination, true), gettype($noAgentDestination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($noAgentDestination) && mb_strlen($noAgentDestination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($noAgentDestination)), __LINE__);
        }
        $this->noAgentDestination = $noAgentDestination;
        return $this;
    }
    /**
     * Get callingSearchSpaceNoAgent value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceNoAgent()
    {
        return $this->callingSearchSpaceNoAgent;
    }
    /**
     * Set callingSearchSpaceNoAgent value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setCallingSearchSpaceNoAgent(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceNoAgent = null)
    {
        $this->callingSearchSpaceNoAgent = $callingSearchSpaceNoAgent;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceID value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceID()
    {
        return $this->networkHoldMohAudioSourceID;
    }
    /**
     * Set networkHoldMohAudioSourceID value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceID
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setNetworkHoldMohAudioSourceID($networkHoldMohAudioSourceID = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($networkHoldMohAudioSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($networkHoldMohAudioSourceID) ? implode(', ', $networkHoldMohAudioSourceID) : var_export($networkHoldMohAudioSourceID, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceID = $networkHoldMohAudioSourceID;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallsQueue
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
