<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallForwardNoCoverageInt StructType
 * @subpackage Structs
 */
class LCallForwardNoCoverageInt extends AbstractStructBase
{
    /**
     * The forwardToVoiceMail
     * Meta information extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * Constructor method for LCallForwardNoCoverageInt
     * @uses LCallForwardNoCoverageInt::setForwardToVoiceMail()
     * @uses LCallForwardNoCoverageInt::setCallingSearchSpaceName()
     * @uses LCallForwardNoCoverageInt::setDestination()
     * @param string $forwardToVoiceMail
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     */
    public function __construct($forwardToVoiceMail = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, $destination = null)
    {
        $this
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination);
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallForwardNoCoverageInt
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardToVoiceMail, true), gettype($forwardToVoiceMail)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallForwardNoCoverageInt
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LCallForwardNoCoverageInt
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($destination) && mb_strlen($destination) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
}
