<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for isdnNsfInfoElement StructType
 * @subpackage Structs
 */
class IsdnNsfInfoElement extends AbstractStructBase
{
    /**
     * The cic
     * Meta information extracted from the WSDL
     * - documentation: If not specified then a default value of '0' is set. This tag is not applicable to networkServiceProtocol PRI NI2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cic;
    /**
     * The networkServiceProtocol
     * Meta information extracted from the WSDL
     * - documentation: It is a mandatory tag if anychild tag of isdnNSFInfoElement is specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkServiceProtocol;
    /**
     * The networkService
     * Meta information extracted from the WSDL
     * - documentation: If not specified then the first record based on the protocol in NSFProtocolServiceMap table will be set as the default value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkService;
    /**
     * The paramValue
     * Meta information extracted from the WSDL
     * - documentation: This parameter will take effect only if the selected network service has a valid parameterName in TypeNSFService.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $paramValue;
    /**
     * Constructor method for isdnNsfInfoElement
     * @uses IsdnNsfInfoElement::setCic()
     * @uses IsdnNsfInfoElement::setNetworkServiceProtocol()
     * @uses IsdnNsfInfoElement::setNetworkService()
     * @uses IsdnNsfInfoElement::setParamValue()
     * @param string $cic
     * @param string $networkServiceProtocol
     * @param string $networkService
     * @param string $paramValue
     */
    public function __construct($cic = null, $networkServiceProtocol = null, $networkService = null, $paramValue = null)
    {
        $this
            ->setCic($cic)
            ->setNetworkServiceProtocol($networkServiceProtocol)
            ->setNetworkService($networkService)
            ->setParamValue($paramValue);
    }
    /**
     * Get cic value
     * @return string|null
     */
    public function getCic()
    {
        return $this->cic;
    }
    /**
     * Set cic value
     * @param string $cic
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public function setCic($cic = null)
    {
        // validation for constraint: string
        if (!is_null($cic) && !is_string($cic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cic, true), gettype($cic)), __LINE__);
        }
        $this->cic = $cic;
        return $this;
    }
    /**
     * Get networkServiceProtocol value
     * @return string|null
     */
    public function getNetworkServiceProtocol()
    {
        return $this->networkServiceProtocol;
    }
    /**
     * Set networkServiceProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkServiceProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public function setNetworkServiceProtocol($networkServiceProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::valueIsValid($networkServiceProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol', is_array($networkServiceProtocol) ? implode(', ', $networkServiceProtocol) : var_export($networkServiceProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriProtocol::getValidValues())), __LINE__);
        }
        $this->networkServiceProtocol = $networkServiceProtocol;
        return $this;
    }
    /**
     * Get networkService value
     * @return string|null
     */
    public function getNetworkService()
    {
        return $this->networkService;
    }
    /**
     * Set networkService value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNSFService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNSFService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkService
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public function setNetworkService($networkService = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNSFService::valueIsValid($networkService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNSFService', is_array($networkService) ? implode(', ', $networkService) : var_export($networkService, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNSFService::getValidValues())), __LINE__);
        }
        $this->networkService = $networkService;
        return $this;
    }
    /**
     * Get paramValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }
    /**
     * Set paramValue value
     * @param string $paramValue
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramValue, true), gettype($paramValue)), __LINE__);
        }
        $this->paramValue = $paramValue;
        return $this;
    }
}
