<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRemoteClusterReq StructType
 * @subpackage Structs
 */
class GetRemoteClusterReq extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: clusterId | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: clusterId | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetRemoteClusterReq
     * @uses GetRemoteClusterReq::setClusterId()
     * @uses GetRemoteClusterReq::setUuid()
     * @uses GetRemoteClusterReq::setReturnedTags()
     * @uses GetRemoteClusterReq::setSequence()
     * @param string $clusterId
     * @param string $uuid
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster $returnedTags
     * @param int $sequence
     */
    public function __construct($clusterId = null, $uuid = null, \Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster $returnedTags = null, $sequence = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return isset($this->clusterId) ? $this->clusterId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClusterId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClusterId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClusterIdForChoiceConstraintsFromSetClusterId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property clusterId can\'t be set as the property %s is already set. Only one property must be set among these properties: clusterId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set clusterId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $clusterId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        // validation for constraint: choice(clusterId, uuid)
        if ('' !== ($clusterIdChoiceErrorMessage = self::validateClusterIdForChoiceConstraintsFromSetClusterId($clusterId))) {
            throw new \InvalidArgumentException($clusterIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clusterId) && mb_strlen($clusterId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clusterId)), __LINE__);
        }
        if (is_null($clusterId) || (is_array($clusterId) && empty($clusterId))) {
            unset($this->clusterId);
        } else {
            $this->clusterId = $clusterId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'clusterId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(clusterId, uuid)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster $returnedTags
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq
     */
    public function setReturnedTags(\Losc\CucmBundle\Model\Webservice\StructType\RRemoteCluster $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetRemoteClusterReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
