<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneTypeDisplayInstanceReq StructType
 * @subpackage Structs
 */
class GetPhoneTypeDisplayInstanceReq extends APIRequest
{
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - minOccurs: 1
     * @var string
     */
    public $productName;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - minOccurs: 1
     * @var string
     */
    public $protocol;
    /**
     * Constructor method for GetPhoneTypeDisplayInstanceReq
     * @uses GetPhoneTypeDisplayInstanceReq::setProductName()
     * @uses GetPhoneTypeDisplayInstanceReq::setProtocol()
     * @param string $productName
     * @param string $protocol
     */
    public function __construct($productName = null, $protocol = null)
    {
        $this
            ->setProductName($productName)
            ->setProtocol($protocol);
    }
    /**
     * Get productName value
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceReq
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($productName) && mb_strlen($productName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\GetPhoneTypeDisplayInstanceReq
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocol, true), gettype($protocol)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($protocol) && mb_strlen($protocol) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
}
