<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for currentConfig StructType
 * Meta information extracted from the WSDL
 * - documentation: This tag is valid only for a get deviceprofile response.It contains Extension Mobility related parameters for a device when a user is logged in using a user defined device profile.If no user is logged in,the original device
 * information for these parameters is returned. | This tag is valid only for a get phone response.It contains Extension Mobility related parameters for a device when a user is logged in using a user defined device profile.If no user is logged in,the
 * original device information for these parameters is returned.
 * @subpackage Structs
 */
class CurrentConfig extends AbstractStructBase
{
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The emccCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $emccCallingSearchSpaceName;
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceName;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The deviceProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceProtocol;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The addressMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $addressMode;
    /**
     * The allowAutoConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowAutoConfig;
    /**
     * The remoteSrstOption
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSrstOption;
    /**
     * The remoteSrstIp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSrstIp;
    /**
     * The remoteSrstPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSrstPort;
    /**
     * The remoteSipSrstIp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSipSrstIp;
    /**
     * The remoteSipSrstPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteSipSrstPort;
    /**
     * The geolocationInfo
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2048
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geolocationInfo;
    /**
     * The remoteLocationName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteLocationName;
    /**
     * Constructor method for currentConfig
     * @uses CurrentConfig::setUserHoldMohAudioSourceId()
     * @uses CurrentConfig::setPhoneTemplateName()
     * @uses CurrentConfig::setMlppDomainId()
     * @uses CurrentConfig::setMlppIndicationStatus()
     * @uses CurrentConfig::setPreemption()
     * @uses CurrentConfig::setSoftkeyTemplateName()
     * @uses CurrentConfig::setIgnorePresentationIndicators()
     * @uses CurrentConfig::setSingleButtonBarge()
     * @uses CurrentConfig::setJoinAcrossLines()
     * @uses CurrentConfig::setCallInfoPrivacyStatus()
     * @uses CurrentConfig::setDndStatus()
     * @uses CurrentConfig::setDndRingSetting()
     * @uses CurrentConfig::setDndOption()
     * @uses CurrentConfig::setAlwaysUsePrimeLine()
     * @uses CurrentConfig::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses CurrentConfig::setEmccCallingSearchSpaceName()
     * @uses CurrentConfig::setDeviceName()
     * @uses CurrentConfig::setModel()
     * @uses CurrentConfig::setProduct()
     * @uses CurrentConfig::setDeviceProtocol()
     * @uses CurrentConfig::setClass()
     * @uses CurrentConfig::setAddressMode()
     * @uses CurrentConfig::setAllowAutoConfig()
     * @uses CurrentConfig::setRemoteSrstOption()
     * @uses CurrentConfig::setRemoteSrstIp()
     * @uses CurrentConfig::setRemoteSrstPort()
     * @uses CurrentConfig::setRemoteSipSrstIp()
     * @uses CurrentConfig::setRemoteSipSrstPort()
     * @uses CurrentConfig::setGeolocationInfo()
     * @uses CurrentConfig::setRemoteLocationName()
     * @param string $userHoldMohAudioSourceId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @param string $ignorePresentationIndicators
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $callInfoPrivacyStatus
     * @param string $dndStatus
     * @param string $dndRingSetting
     * @param string $dndOption
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpaceName
     * @param string $deviceName
     * @param string $model
     * @param string $product
     * @param string $deviceProtocol
     * @param string $class
     * @param string $addressMode
     * @param string $allowAutoConfig
     * @param string $remoteSrstOption
     * @param string $remoteSrstIp
     * @param string $remoteSrstPort
     * @param string $remoteSipSrstIp
     * @param string $remoteSipSrstPort
     * @param string $geolocationInfo
     * @param string $remoteLocationName
     */
    public function __construct($userHoldMohAudioSourceId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null, $ignorePresentationIndicators = null, $singleButtonBarge = null, $joinAcrossLines = null, $callInfoPrivacyStatus = null, $dndStatus = null, $dndRingSetting = null, $dndOption = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpaceName = null, $deviceName = null, $model = null, $product = null, $deviceProtocol = null, $class = null, $addressMode = null, $allowAutoConfig = null, $remoteSrstOption = null, $remoteSrstIp = null, $remoteSrstPort = null, $remoteSipSrstIp = null, $remoteSipSrstPort = null, $geolocationInfo = null, $remoteLocationName = null)
    {
        $this
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setDndStatus($dndStatus)
            ->setDndRingSetting($dndRingSetting)
            ->setDndOption($dndOption)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setEmccCallingSearchSpaceName($emccCallingSearchSpaceName)
            ->setDeviceName($deviceName)
            ->setModel($model)
            ->setProduct($product)
            ->setDeviceProtocol($deviceProtocol)
            ->setClass($class)
            ->setAddressMode($addressMode)
            ->setAllowAutoConfig($allowAutoConfig)
            ->setRemoteSrstOption($remoteSrstOption)
            ->setRemoteSrstIp($remoteSrstIp)
            ->setRemoteSrstPort($remoteSrstPort)
            ->setRemoteSipSrstIp($remoteSipSrstIp)
            ->setRemoteSipSrstPort($remoteSipSrstPort)
            ->setGeolocationInfo($geolocationInfo)
            ->setRemoteLocationName($remoteLocationName);
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($userHoldMohAudioSourceId) ? implode(', ', $userHoldMohAudioSourceId) : var_export($userHoldMohAudioSourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setPhoneTemplateName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppDomainId, true), gettype($mlppDomainId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mlppDomainId) && mb_strlen($mlppDomainId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setSoftkeyTemplateName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignorePresentationIndicators, true), gettype($ignorePresentationIndicators)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBarge::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XBarge', is_array($singleButtonBarge) ? implode(', ', $singleButtonBarge) : var_export($singleButtonBarge, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($joinAcrossLines) ? implode(', ', $joinAcrossLines) : var_export($joinAcrossLines, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($callInfoPrivacyStatus) ? implode(', ', $callInfoPrivacyStatus) : var_export($callInfoPrivacyStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dndStatus, true), gettype($dndStatus)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($dndStatus, true)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting', is_array($dndRingSetting) ? implode(', ', $dndRingSetting) : var_export($dndRingSetting, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption', is_array($dndOption) ? implode(', ', $dndOption) : var_export($dndOption, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLine) ? implode(', ', $alwaysUsePrimeLine) : var_export($alwaysUsePrimeLine, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($alwaysUsePrimeLineForVoiceMessage) ? implode(', ', $alwaysUsePrimeLineForVoiceMessage) : var_export($alwaysUsePrimeLineForVoiceMessage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get emccCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getEmccCallingSearchSpaceName()
    {
        return $this->emccCallingSearchSpaceName;
    }
    /**
     * Set emccCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setEmccCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpaceName = null)
    {
        $this->emccCallingSearchSpaceName = $emccCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get deviceName value
     * @return string|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param string $deviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($deviceName) && mb_strlen($deviceName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($deviceName)), __LINE__);
        }
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get deviceProtocol value
     * @return string|null
     */
    public function getDeviceProtocol()
    {
        return $this->deviceProtocol;
    }
    /**
     * Set deviceProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setDeviceProtocol($deviceProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($deviceProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($deviceProtocol) ? implode(', ', $deviceProtocol) : var_export($deviceProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->deviceProtocol = $deviceProtocol;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get addressMode value
     * @return string|null
     */
    public function getAddressMode()
    {
        return $this->addressMode;
    }
    /**
     * Set addressMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XIPAddressingMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XIPAddressingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setAddressMode($addressMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XIPAddressingMode::valueIsValid($addressMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XIPAddressingMode', is_array($addressMode) ? implode(', ', $addressMode) : var_export($addressMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XIPAddressingMode::getValidValues())), __LINE__);
        }
        $this->addressMode = $addressMode;
        return $this;
    }
    /**
     * Get allowAutoConfig value
     * @return string|null
     */
    public function getAllowAutoConfig()
    {
        return $this->allowAutoConfig;
    }
    /**
     * Set allowAutoConfig value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowAutoConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setAllowAutoConfig($allowAutoConfig = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($allowAutoConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($allowAutoConfig) ? implode(', ', $allowAutoConfig) : var_export($allowAutoConfig, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->allowAutoConfig = $allowAutoConfig;
        return $this;
    }
    /**
     * Get remoteSrstOption value
     * @return string|null
     */
    public function getRemoteSrstOption()
    {
        return $this->remoteSrstOption;
    }
    /**
     * Set remoteSrstOption value
     * @param string $remoteSrstOption
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteSrstOption($remoteSrstOption = null)
    {
        // validation for constraint: string
        if (!is_null($remoteSrstOption) && !is_string($remoteSrstOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteSrstOption, true), gettype($remoteSrstOption)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($remoteSrstOption) && mb_strlen($remoteSrstOption) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($remoteSrstOption)), __LINE__);
        }
        $this->remoteSrstOption = $remoteSrstOption;
        return $this;
    }
    /**
     * Get remoteSrstIp value
     * @return string|null
     */
    public function getRemoteSrstIp()
    {
        return $this->remoteSrstIp;
    }
    /**
     * Set remoteSrstIp value
     * @param string $remoteSrstIp
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteSrstIp($remoteSrstIp = null)
    {
        // validation for constraint: string
        if (!is_null($remoteSrstIp) && !is_string($remoteSrstIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteSrstIp, true), gettype($remoteSrstIp)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($remoteSrstIp) && mb_strlen($remoteSrstIp) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($remoteSrstIp)), __LINE__);
        }
        $this->remoteSrstIp = $remoteSrstIp;
        return $this;
    }
    /**
     * Get remoteSrstPort value
     * @return string|null
     */
    public function getRemoteSrstPort()
    {
        return $this->remoteSrstPort;
    }
    /**
     * Set remoteSrstPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteSrstPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteSrstPort($remoteSrstPort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($remoteSrstPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($remoteSrstPort) ? implode(', ', $remoteSrstPort) : var_export($remoteSrstPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteSrstPort = $remoteSrstPort;
        return $this;
    }
    /**
     * Get remoteSipSrstIp value
     * @return string|null
     */
    public function getRemoteSipSrstIp()
    {
        return $this->remoteSipSrstIp;
    }
    /**
     * Set remoteSipSrstIp value
     * @param string $remoteSipSrstIp
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteSipSrstIp($remoteSipSrstIp = null)
    {
        // validation for constraint: string
        if (!is_null($remoteSipSrstIp) && !is_string($remoteSipSrstIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteSipSrstIp, true), gettype($remoteSipSrstIp)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($remoteSipSrstIp) && mb_strlen($remoteSipSrstIp) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($remoteSipSrstIp)), __LINE__);
        }
        $this->remoteSipSrstIp = $remoteSipSrstIp;
        return $this;
    }
    /**
     * Get remoteSipSrstPort value
     * @return string|null
     */
    public function getRemoteSipSrstPort()
    {
        return $this->remoteSipSrstPort;
    }
    /**
     * Set remoteSipSrstPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteSipSrstPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteSipSrstPort($remoteSipSrstPort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($remoteSipSrstPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($remoteSipSrstPort) ? implode(', ', $remoteSipSrstPort) : var_export($remoteSipSrstPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteSipSrstPort = $remoteSipSrstPort;
        return $this;
    }
    /**
     * Get geolocationInfo value
     * @return string|null
     */
    public function getGeolocationInfo()
    {
        return $this->geolocationInfo;
    }
    /**
     * Set geolocationInfo value
     * @param string $geolocationInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setGeolocationInfo($geolocationInfo = null)
    {
        // validation for constraint: string
        if (!is_null($geolocationInfo) && !is_string($geolocationInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geolocationInfo, true), gettype($geolocationInfo)), __LINE__);
        }
        // validation for constraint: maxLength(2048)
        if (!is_null($geolocationInfo) && mb_strlen($geolocationInfo) > 2048) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2048', mb_strlen($geolocationInfo)), __LINE__);
        }
        $this->geolocationInfo = $geolocationInfo;
        return $this;
    }
    /**
     * Get remoteLocationName value
     * @return string|null
     */
    public function getRemoteLocationName()
    {
        return $this->remoteLocationName;
    }
    /**
     * Set remoteLocationName value
     * @param string $remoteLocationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CurrentConfig
     */
    public function setRemoteLocationName($remoteLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($remoteLocationName) && !is_string($remoteLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteLocationName, true), gettype($remoteLocationName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($remoteLocationName) && mb_strlen($remoteLocationName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($remoteLocationName)), __LINE__);
        }
        $this->remoteLocationName = $remoteLocationName;
        return $this;
    }
}
