<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for componentVersion StructType
 * @subpackage Structs
 */
class ComponentVersion extends AbstractStructBase
{
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $version;
    /**
     * Constructor method for componentVersion
     * @uses ComponentVersion::setVersion()
     * @param string $version
     */
    public function __construct($version = null)
    {
        $this
            ->setVersion($version);
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ComponentVersion
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($version) && mb_strlen($version) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
