<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for audioSource StructType
 * @subpackage Structs
 */
class AudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sourceId;
    /**
     * The maxHops
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxHops;
    /**
     * Constructor method for audioSource
     * @uses AudioSource::setSourceId()
     * @uses AudioSource::setMaxHops()
     * @param string $sourceId
     * @param string $maxHops
     */
    public function __construct($sourceId = null, $maxHops = '2')
    {
        $this
            ->setSourceId($sourceId)
            ->setMaxHops($maxHops);
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($sourceId) ? implode(', ', $sourceId) : var_export($sourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get maxHops value
     * @return string|null
     */
    public function getMaxHops()
    {
        return $this->maxHops;
    }
    /**
     * Set maxHops value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHops
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AudioSource
     */
    public function setMaxHops($maxHops = '2')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxHops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxHops) ? implode(', ', $maxHops) : var_export($maxHops, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxHops = $maxHops;
        return $this;
    }
}
