<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedBlfSdFeatures StructType
 * @subpackage Structs
 */
class AssociatedBlfSdFeatures extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $feature;
    /**
     * Constructor method for associatedBlfSdFeatures
     * @uses AssociatedBlfSdFeatures::setFeature()
     * @param string[] $feature
     */
    public function __construct(array $feature = array())
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get feature value
     * @return string[]|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * This method is responsible for validating the values passed to the setFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeatureForArrayConstraintsFromSetFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedBlfSdFeaturesFeatureItem) {
            // validation for constraint: enumeration
            if (!\Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::valueIsValid($associatedBlfSdFeaturesFeatureItem)) {
                $invalidValues[] = is_object($associatedBlfSdFeaturesFeatureItem) ? get_class($associatedBlfSdFeaturesFeatureItem) : sprintf('%s(%s)', gettype($associatedBlfSdFeaturesFeatureItem), var_export($associatedBlfSdFeaturesFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set feature value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $feature
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedBlfSdFeatures
     */
    public function setFeature(array $feature = array())
    {
        // validation for constraint: array
        if ('' !== ($featureArrayErrorMessage = self::validateFeatureForArrayConstraintsFromSetFeature($feature))) {
            throw new \InvalidArgumentException($featureArrayErrorMessage, __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Add item to feature value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedBlfSdFeatures
     */
    public function addToFeature($item)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XBLFSDOption::getValidValues())), __LINE__);
        }
        $this->feature[] = $item;
        return $this;
    }
}
