<?php

namespace Losc\CucmBundle\Model\Webservice\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Apply ServiceType
 * @subpackage Services
 */
class Apply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named applySipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applySipProfile(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applySipTrunkSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyRoutePartition(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCallManager(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyRegion(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyDevicePool(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applySoftKeyTemplate(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyTranscoder(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCommonDeviceConfig(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ApplyResourcePriorityNamespaceReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyResourcePriorityNamespace(\Losc\CucmBundle\Model\Webservice\StructType\ApplyResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyResourcePriorityNamespaceList(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyHuntList(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCallManagerGroup(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ApplyDirectedCallParkReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyDirectedCallPark(\Losc\CucmBundle\Model\Webservice\StructType\ApplyDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyRouteList(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyDateTimeGroup(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applySrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applySrst(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applySrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyVoiceMailProfile(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyVoiceMailPort(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyGatekeeper(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyPhoneButtonTemplate(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCommonPhoneConfig(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCtiRoutePoint(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyPhoneSecurityProfile(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyConferenceBridge(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyMtp(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ApplyLineReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyLine(\Losc\CucmBundle\Model\Webservice\StructType\ApplyLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyH323Phone(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyPhone(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyH323Gateway(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named applyGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ApplyGatewayReq $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyGateway(\Losc\CucmBundle\Model\Webservice\StructType\ApplyGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst600024PortFXSGateway(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000E1VoIPGateway(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000T1VoIPGatewayPri(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * applyCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse|bool
     */
    public function applyCiscoCatalyst6000T1VoIPGatewayT1(\Losc\CucmBundle\Model\Webservice\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->applyCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Losc\CucmBundle\Model\Webservice\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
