<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XUCProduct EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XUCProduct extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unity'
     * @return string 'Unity'
     */
    const VALUE_UNITY = 'Unity';
    /**
     * Constant for value 'Unity Connection'
     * @return string 'Unity Connection'
     */
    const VALUE_UNITY_CONNECTION = 'Unity Connection';
    /**
     * Constant for value 'Exchange'
     * @return string 'Exchange'
     */
    const VALUE_EXCHANGE = 'Exchange';
    /**
     * Constant for value 'MeetingPlace Classic'
     * @return string 'MeetingPlace Classic'
     */
    const VALUE_MEETING_PLACE_CLASSIC = 'MeetingPlace Classic';
    /**
     * Constant for value 'MeetingPlace Express'
     * @return string 'MeetingPlace Express'
     */
    const VALUE_MEETING_PLACE_EXPRESS = 'MeetingPlace Express';
    /**
     * Constant for value 'WebEx (Conferencing)'
     * @return string 'WebEx (Conferencing)'
     */
    const VALUE_WEB_EX_CONFERENCING = 'WebEx (Conferencing)';
    /**
     * Constant for value 'Directory'
     * @return string 'Directory'
     */
    const VALUE_DIRECTORY = 'Directory';
    /**
     * Constant for value 'Unified CM (IM and Presence)'
     * @return string 'Unified CM (IM and Presence)'
     */
    const VALUE_UNIFIED_CM_IM_AND_PRESENCE = 'Unified CM (IM and Presence)';
    /**
     * Constant for value 'WebEx (IM and Presence)'
     * @return string 'WebEx (IM and Presence)'
     */
    const VALUE_WEB_EX_IM_AND_PRESENCE = 'WebEx (IM and Presence)';
    /**
     * Constant for value 'CTI'
     * @return string 'CTI'
     */
    const VALUE_CTI = 'CTI';
    /**
     * Constant for value 'Enhanced Directory'
     * @return string 'Enhanced Directory'
     */
    const VALUE_ENHANCED_DIRECTORY = 'Enhanced Directory';
    /**
     * Constant for value 'Telepresence Management System'
     * @return string 'Telepresence Management System'
     */
    const VALUE_TELEPRESENCE_MANAGEMENT_SYSTEM = 'Telepresence Management System';
    /**
     * Return allowed values
     * @uses self::VALUE_UNITY
     * @uses self::VALUE_UNITY_CONNECTION
     * @uses self::VALUE_EXCHANGE
     * @uses self::VALUE_MEETING_PLACE_CLASSIC
     * @uses self::VALUE_MEETING_PLACE_EXPRESS
     * @uses self::VALUE_WEB_EX_CONFERENCING
     * @uses self::VALUE_DIRECTORY
     * @uses self::VALUE_UNIFIED_CM_IM_AND_PRESENCE
     * @uses self::VALUE_WEB_EX_IM_AND_PRESENCE
     * @uses self::VALUE_CTI
     * @uses self::VALUE_ENHANCED_DIRECTORY
     * @uses self::VALUE_TELEPRESENCE_MANAGEMENT_SYSTEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNITY,
            self::VALUE_UNITY_CONNECTION,
            self::VALUE_EXCHANGE,
            self::VALUE_MEETING_PLACE_CLASSIC,
            self::VALUE_MEETING_PLACE_EXPRESS,
            self::VALUE_WEB_EX_CONFERENCING,
            self::VALUE_DIRECTORY,
            self::VALUE_UNIFIED_CM_IM_AND_PRESENCE,
            self::VALUE_WEB_EX_IM_AND_PRESENCE,
            self::VALUE_CTI,
            self::VALUE_ENHANCED_DIRECTORY,
            self::VALUE_TELEPRESENCE_MANAGEMENT_SYSTEM,
        );
    }
}
