<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XSIPRel1XXOptions EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XSIPRel1XXOptions extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'Send PRACK if 1xx Contains SDP'
     * @return string 'Send PRACK if 1xx Contains SDP'
     */
    const VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP = 'Send PRACK if 1xx Contains SDP';
    /**
     * Constant for value 'Send PRACK for all 1xx Messages'
     * @return string 'Send PRACK for all 1xx Messages'
     */
    const VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES = 'Send PRACK for all 1xx Messages';
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP
     * @uses self::VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLED,
            self::VALUE_SEND_PRACK_IF_1_XX_CONTAINS_SDP,
            self::VALUE_SEND_PRACK_FOR_ALL_1_XX_MESSAGES,
        );
    }
}
