<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XOutboundCallRollover EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XOutboundCallRollover extends AbstractStructEnumBase
{
    /**
     * Constant for value 'No Rollover'
     * @return string 'No Rollover'
     */
    const VALUE_NO_ROLLOVER = 'No Rollover';
    /**
     * Constant for value 'Rollover Within Same DN'
     * @return string 'Rollover Within Same DN'
     */
    const VALUE_ROLLOVER_WITHIN_SAME_DN = 'Rollover Within Same DN';
    /**
     * Constant for value 'Rollover to any line'
     * @return string 'Rollover to any line'
     */
    const VALUE_ROLLOVER_TO_ANY_LINE = 'Rollover to any line';
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ROLLOVER
     * @uses self::VALUE_ROLLOVER_WITHIN_SAME_DN
     * @uses self::VALUE_ROLLOVER_TO_ANY_LINE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ROLLOVER,
            self::VALUE_ROLLOVER_WITHIN_SAME_DN,
            self::VALUE_ROLLOVER_TO_ANY_LINE,
        );
    }
}
