<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XMatrixValue EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XMatrixValue extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'No Reservation'
     * @return string 'No Reservation'
     */
    const VALUE_NO_RESERVATION = 'No Reservation';
    /**
     * Constant for value 'Optional(Video Desired)'
     * @return string 'Optional(Video Desired)'
     */
    const VALUE_OPTIONAL_VIDEO_DESIRED = 'Optional(Video Desired)';
    /**
     * Constant for value 'Mandatory'
     * @return string 'Mandatory'
     */
    const VALUE_MANDATORY = 'Mandatory';
    /**
     * Constant for value 'Mandatory(Video Desired)'
     * @return string 'Mandatory(Video Desired)'
     */
    const VALUE_MANDATORY_VIDEO_DESIRED = 'Mandatory(Video Desired)';
    /**
     * Constant for value 'Allow Subscription'
     * @return string 'Allow Subscription'
     */
    const VALUE_ALLOW_SUBSCRIPTION = 'Allow Subscription';
    /**
     * Constant for value 'Disallow Subscription'
     * @return string 'Disallow Subscription'
     */
    const VALUE_DISALLOW_SUBSCRIPTION = 'Disallow Subscription';
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_NO_RESERVATION
     * @uses self::VALUE_OPTIONAL_VIDEO_DESIRED
     * @uses self::VALUE_MANDATORY
     * @uses self::VALUE_MANDATORY_VIDEO_DESIRED
     * @uses self::VALUE_ALLOW_SUBSCRIPTION
     * @uses self::VALUE_DISALLOW_SUBSCRIPTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_NO_RESERVATION,
            self::VALUE_OPTIONAL_VIDEO_DESIRED,
            self::VALUE_MANDATORY,
            self::VALUE_MANDATORY_VIDEO_DESIRED,
            self::VALUE_ALLOW_SUBSCRIPTION,
            self::VALUE_DISALLOW_SUBSCRIPTION,
        );
    }
}
