<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XHuntAlgorithm EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XHuntAlgorithm extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Try next member; then, try next group in Hunt List'
     * @return string 'Try next member; then, try next group in Hunt List'
     */
    const VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST = 'Try next member; then, try next group in Hunt List';
    /**
     * Constant for value 'Try next member, but do not go to next group'
     * @return string 'Try next member, but do not go to next group'
     */
    const VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP = 'Try next member, but do not go to next group';
    /**
     * Constant for value 'Skip remaining members, and go directly to next group'
     * @return string 'Skip remaining members, and go directly to next group'
     */
    const VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP = 'Skip remaining members, and go directly to next group';
    /**
     * Constant for value 'Stop hunting'
     * @return string 'Stop hunting'
     */
    const VALUE_STOP_HUNTING = 'Stop hunting';
    /**
     * Return allowed values
     * @uses self::VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST
     * @uses self::VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP
     * @uses self::VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP
     * @uses self::VALUE_STOP_HUNTING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST,
            self::VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP,
            self::VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP,
            self::VALUE_STOP_HUNTING,
        );
    }
}
