<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XCertificateVerificationLevel EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XCertificateVerificationLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Any Certificate'
     * @return string 'Any Certificate'
     */
    const VALUE_ANY_CERTIFICATE = 'Any Certificate';
    /**
     * Constant for value 'Self-signed or Keystore'
     * @return string 'Self-signed or Keystore'
     */
    const VALUE_SELF_SIGNED_OR_KEYSTORE = 'Self-signed or Keystore';
    /**
     * Constant for value 'Keystore Only'
     * @return string 'Keystore Only'
     */
    const VALUE_KEYSTORE_ONLY = 'Keystore Only';
    /**
     * Return allowed values
     * @uses self::VALUE_ANY_CERTIFICATE
     * @uses self::VALUE_SELF_SIGNED_OR_KEYSTORE
     * @uses self::VALUE_KEYSTORE_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY_CERTIFICATE,
            self::VALUE_SELF_SIGNED_OR_KEYSTORE,
            self::VALUE_KEYSTORE_ONLY,
        );
    }
}
