<?php

namespace Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XAppServer EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XAppServer extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Cisco Unity Voice Mail 4.x or later'
     * @return string 'Cisco Unity Voice Mail 4.x or later'
     */
    const VALUE_CISCO_UNITY_VOICE_MAIL_4_X_OR_LATER = 'Cisco Unity Voice Mail 4.x or later';
    /**
     * Constant for value 'Cisco Unity Connection'
     * @return string 'Cisco Unity Connection'
     */
    const VALUE_CISCO_UNITY_CONNECTION = 'Cisco Unity Connection';
    /**
     * Constant for value 'Cisco Unified CM IM and Presence (Obsolete)'
     * @return string 'Cisco Unified CM IM and Presence (Obsolete)'
     */
    const VALUE_CISCO_UNIFIED_CM_IM_AND_PRESENCE_OBSOLETE = 'Cisco Unified CM IM and Presence (Obsolete)';
    /**
     * Constant for value 'CUMA Provisioning Server'
     * @return string 'CUMA Provisioning Server'
     */
    const VALUE_CUMA_PROVISIONING_SERVER = 'CUMA Provisioning Server';
    /**
     * Constant for value 'CER Location Management'
     * @return string 'CER Location Management'
     */
    const VALUE_CER_LOCATION_MANAGEMENT = 'CER Location Management';
    /**
     * Constant for value 'Cisco Web Dialer'
     * @return string 'Cisco Web Dialer'
     */
    const VALUE_CISCO_WEB_DIALER = 'Cisco Web Dialer';
    /**
     * Constant for value 'Remote Syslog Server'
     * @return string 'Remote Syslog Server'
     */
    const VALUE_REMOTE_SYSLOG_SERVER = 'Remote Syslog Server';
    /**
     * Return allowed values
     * @uses self::VALUE_CISCO_UNITY_VOICE_MAIL_4_X_OR_LATER
     * @uses self::VALUE_CISCO_UNITY_CONNECTION
     * @uses self::VALUE_CISCO_UNIFIED_CM_IM_AND_PRESENCE_OBSOLETE
     * @uses self::VALUE_CUMA_PROVISIONING_SERVER
     * @uses self::VALUE_CER_LOCATION_MANAGEMENT
     * @uses self::VALUE_CISCO_WEB_DIALER
     * @uses self::VALUE_REMOTE_SYSLOG_SERVER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CISCO_UNITY_VOICE_MAIL_4_X_OR_LATER,
            self::VALUE_CISCO_UNITY_CONNECTION,
            self::VALUE_CISCO_UNIFIED_CM_IM_AND_PRESENCE_OBSOLETE,
            self::VALUE_CUMA_PROVISIONING_SERVER,
            self::VALUE_CER_LOCATION_MANAGEMENT,
            self::VALUE_CISCO_WEB_DIALER,
            self::VALUE_REMOTE_SYSLOG_SERVER,
        );
    }
}
