<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XWifiHotspot StructType
 * @subpackage Structs
 */
class XWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ssidPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ssidPrefix;
    /**
     * The frequencyBand
     * Meta information extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMethod;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The userModifiable
     * Meta information extracted from the WSDL
     * - default: Allowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 1812
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $passwordDescription;
    /**
     * Constructor method for XWifiHotspot
     * @uses XWifiHotspot::setName()
     * @uses XWifiHotspot::setSsidPrefix()
     * @uses XWifiHotspot::setFrequencyBand()
     * @uses XWifiHotspot::setAuthenticationMethod()
     * @uses XWifiHotspot::setDescription()
     * @uses XWifiHotspot::setUserModifiable()
     * @uses XWifiHotspot::setHostName()
     * @uses XWifiHotspot::setPort()
     * @uses XWifiHotspot::setSharedSecret()
     * @uses XWifiHotspot::setPskPassPhrase()
     * @uses XWifiHotspot::setWepKey()
     * @uses XWifiHotspot::setPasswordDescription()
     * @param string $name
     * @param string $ssidPrefix
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $description
     * @param string $userModifiable
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     */
    public function __construct($name = null, $ssidPrefix = null, $frequencyBand = 'Auto', $authenticationMethod = 'None', $description = null, $userModifiable = 'Allowed', $hostName = null, $port = '1812', $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null)
    {
        $this
            ->setName($name)
            ->setSsidPrefix($ssidPrefix)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setDescription($description)
            ->setUserModifiable($userModifiable)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssidPrefix, true), gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency', is_array($frequencyBand) ? implode(', ', $frequencyBand) : var_export($frequencyBand, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod', is_array($authenticationMethod) ? implode(', ', $authenticationMethod) : var_export($authenticationMethod, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setUserModifiable($userModifiable = 'Allowed')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges', is_array($userModifiable) ? implode(', ', $userModifiable) : var_export($userModifiable, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostName, true), gettype($hostName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($hostName) && mb_strlen($hostName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPort($port = '1812')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedSecret()
    {
        return isset($this->sharedSecret) ? $this->sharedSecret : null;
    }
    /**
     * Set sharedSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedSecret
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setSharedSecret($sharedSecret = null)
    {
        // validation for constraint: string
        if (!is_null($sharedSecret) && !is_string($sharedSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedSecret, true), gettype($sharedSecret)), __LINE__);
        }
        if (is_null($sharedSecret) || (is_array($sharedSecret) && empty($sharedSecret))) {
            unset($this->sharedSecret);
        } else {
            $this->sharedSecret = $sharedSecret;
        }
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return isset($this->pskPassPhrase) ? $this->pskPassPhrase : null;
    }
    /**
     * Set pskPassPhrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pskPassPhrase
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassPhrase) && !is_string($pskPassPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pskPassPhrase, true), gettype($pskPassPhrase)), __LINE__);
        }
        if (is_null($pskPassPhrase) || (is_array($pskPassPhrase) && empty($pskPassPhrase))) {
            unset($this->pskPassPhrase);
        } else {
            $this->pskPassPhrase = $pskPassPhrase;
        }
        return $this;
    }
    /**
     * Get wepKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWepKey()
    {
        return isset($this->wepKey) ? $this->wepKey : null;
    }
    /**
     * Set wepKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wepKey
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wepKey, true), gettype($wepKey)), __LINE__);
        }
        if (is_null($wepKey) || (is_array($wepKey) && empty($wepKey))) {
            unset($this->wepKey);
        } else {
            $this->wepKey = $wepKey;
        }
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XWifiHotspot
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordDescription, true), gettype($passwordDescription)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($passwordDescription) && mb_strlen($passwordDescription) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
}
