<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUserGroup StructType
 * @subpackage Structs
 */
class XUserGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The userRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\UserRoles
     */
    public $userRoles;
    /**
     * Constructor method for XUserGroup
     * @uses XUserGroup::setName()
     * @uses XUserGroup::setMembers()
     * @uses XUserGroup::setUserRoles()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setUserRoles($userRoles);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XUserGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XUserGroup
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get userRoles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UserRoles|null
     */
    public function getUserRoles()
    {
        return $this->userRoles;
    }
    /**
     * Set userRoles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XUserGroup
     */
    public function setUserRoles(\Losc\CucmBundle\Model\Webservice\StructType\UserRoles $userRoles = null)
    {
        $this->userRoles = $userRoles;
        return $this;
    }
}
