<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTransformationProfile StructType
 * @subpackage Structs
 */
class XTransformationProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalCssName;
    /**
     * The internationalCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalCssName;
    /**
     * The unknownCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownCssName;
    /**
     * The subscriberCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberCssName;
    /**
     * Constructor method for XTransformationProfile
     * @uses XTransformationProfile::setName()
     * @uses XTransformationProfile::setDescription()
     * @uses XTransformationProfile::setNationalStripDigits()
     * @uses XTransformationProfile::setInternationalStripDigits()
     * @uses XTransformationProfile::setUnknownStripDigits()
     * @uses XTransformationProfile::setSubscriberStripDigits()
     * @uses XTransformationProfile::setNationalPrefix()
     * @uses XTransformationProfile::setInternationalPrefix()
     * @uses XTransformationProfile::setUnknownPrefix()
     * @uses XTransformationProfile::setSubscriberPrefix()
     * @uses XTransformationProfile::setNationalCssName()
     * @uses XTransformationProfile::setInternationalCssName()
     * @uses XTransformationProfile::setUnknownCssName()
     * @uses XTransformationProfile::setSubscriberCssName()
     * @param string $name
     * @param string $description
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownCssName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberCssName
     */
    public function __construct($name = null, $description = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownCssName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberCssName = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalCssName($nationalCssName)
            ->setInternationalCssName($internationalCssName)
            ->setUnknownCssName($unknownCssName)
            ->setSubscriberCssName($subscriberCssName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return isset($this->nationalStripDigits) ? $this->nationalStripDigits : null;
    }
    /**
     * Set nationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($nationalStripDigits) ? implode(', ', $nationalStripDigits) : var_export($nationalStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($nationalStripDigits) || (is_array($nationalStripDigits) && empty($nationalStripDigits))) {
            unset($this->nationalStripDigits);
        } else {
            $this->nationalStripDigits = $nationalStripDigits;
        }
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return isset($this->internationalStripDigits) ? $this->internationalStripDigits : null;
    }
    /**
     * Set internationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($internationalStripDigits) ? implode(', ', $internationalStripDigits) : var_export($internationalStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($internationalStripDigits) || (is_array($internationalStripDigits) && empty($internationalStripDigits))) {
            unset($this->internationalStripDigits);
        } else {
            $this->internationalStripDigits = $internationalStripDigits;
        }
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($unknownStripDigits) ? implode(', ', $unknownStripDigits) : var_export($unknownStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return isset($this->subscriberStripDigits) ? $this->subscriberStripDigits : null;
    }
    /**
     * Set subscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($subscriberStripDigits) ? implode(', ', $subscriberStripDigits) : var_export($subscriberStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($subscriberStripDigits) || (is_array($subscriberStripDigits) && empty($subscriberStripDigits))) {
            unset($this->subscriberStripDigits);
        } else {
            $this->subscriberStripDigits = $subscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalPrefix, true), gettype($nationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($nationalPrefix) && mb_strlen($nationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalPrefix, true), gettype($internationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($internationalPrefix) && mb_strlen($internationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unknownPrefix, true), gettype($unknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unknownPrefix) && mb_strlen($unknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberPrefix, true), gettype($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($subscriberPrefix) && mb_strlen($subscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalCssName()
    {
        return isset($this->nationalCssName) ? $this->nationalCssName : null;
    }
    /**
     * Set nationalCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setNationalCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalCssName = null)
    {
        if (is_null($nationalCssName) || (is_array($nationalCssName) && empty($nationalCssName))) {
            unset($this->nationalCssName);
        } else {
            $this->nationalCssName = $nationalCssName;
        }
        return $this;
    }
    /**
     * Get internationalCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalCssName()
    {
        return isset($this->internationalCssName) ? $this->internationalCssName : null;
    }
    /**
     * Set internationalCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setInternationalCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalCssName = null)
    {
        if (is_null($internationalCssName) || (is_array($internationalCssName) && empty($internationalCssName))) {
            unset($this->internationalCssName);
        } else {
            $this->internationalCssName = $internationalCssName;
        }
        return $this;
    }
    /**
     * Get unknownCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownCssName()
    {
        return isset($this->unknownCssName) ? $this->unknownCssName : null;
    }
    /**
     * Set unknownCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setUnknownCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownCssName = null)
    {
        if (is_null($unknownCssName) || (is_array($unknownCssName) && empty($unknownCssName))) {
            unset($this->unknownCssName);
        } else {
            $this->unknownCssName = $unknownCssName;
        }
        return $this;
    }
    /**
     * Get subscriberCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberCssName()
    {
        return isset($this->subscriberCssName) ? $this->subscriberCssName : null;
    }
    /**
     * Set subscriberCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTransformationProfile
     */
    public function setSubscriberCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberCssName = null)
    {
        if (is_null($subscriberCssName) || (is_array($subscriberCssName) && empty($subscriberCssName))) {
            unset($this->subscriberCssName);
        } else {
            $this->subscriberCssName = $subscriberCssName;
        }
        return $this;
    }
}
