<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipDialRules StructType
 * @subpackage Structs
 */
class XSipDialRules extends AbstractStructBase
{
    /**
     * The dialPattern
     * Meta information extracted from the WSDL
     * - default: 7940_7960_OTHER
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $dialPattern;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The patterns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Patterns
     */
    public $patterns;
    /**
     * The plars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Plars
     */
    public $plars;
    /**
     * Constructor method for XSipDialRules
     * @uses XSipDialRules::setDialPattern()
     * @uses XSipDialRules::setName()
     * @uses XSipDialRules::setDescription()
     * @uses XSipDialRules::setPatterns()
     * @uses XSipDialRules::setPlars()
     * @param string $dialPattern
     * @param string $name
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     */
    public function __construct($dialPattern = '7940_7960_OTHER', $name = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null, \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null)
    {
        $this
            ->setDialPattern($dialPattern)
            ->setName($name)
            ->setDescription($description)
            ->setPatterns($patterns)
            ->setPlars($plars);
    }
    /**
     * Get dialPattern value
     * @return string
     */
    public function getDialPattern()
    {
        return $this->dialPattern;
    }
    /**
     * Set dialPattern value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSipDialRules
     */
    public function setDialPattern($dialPattern = '7940_7960_OTHER')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::valueIsValid($dialPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern', is_array($dialPattern) ? implode(', ', $dialPattern) : var_export($dialPattern, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDialPattern::getValidValues())), __LINE__);
        }
        $this->dialPattern = $dialPattern;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSipDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSipDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get patterns value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Patterns|null
     */
    public function getPatterns()
    {
        return $this->patterns;
    }
    /**
     * Set patterns value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSipDialRules
     */
    public function setPatterns(\Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null)
    {
        $this->patterns = $patterns;
        return $this;
    }
    /**
     * Get plars value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Plars|null
     */
    public function getPlars()
    {
        return $this->plars;
    }
    /**
     * Set plars value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSipDialRules
     */
    public function setPlars(\Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null)
    {
        $this->plars = $plars;
        return $this;
    }
}
