<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePattern StructType
 * @subpackage Structs
 */
class XRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - default: OnNet
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Destination
     */
    public $destination;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The patternUrgency
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The supportOverlapSending
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for a translation pattern.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $supportOverlapSending;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - default: No Error
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $releaseClause;
    /**
     * The allowDeviceOverride
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowDeviceOverride;
    /**
     * The provideOutsideDialtone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The authorizationCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authorizationCodeRequired;
    /**
     * The authorizationLevelRequired
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authorizationLevelRequired;
    /**
     * The clientCodeRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $clientCodeRequired;
    /**
     * The isdnNsfInfoElement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement
     */
    public $isdnNsfInfoElement;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeClass;
    /**
     * The enableDccEnforcement
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDccEnforcement;
    /**
     * The blockedCallPercentage
     * Meta information extracted from the WSDL
     * - documentation: This tag is only valid when value of enabledccenforcement is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $blockedCallPercentage;
    /**
     * The externalCallControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $externalCallControl;
    /**
     * Constructor method for XRoutePattern
     * @uses XRoutePattern::setPattern()
     * @uses XRoutePattern::setRoutePartitionName()
     * @uses XRoutePattern::setBlockEnable()
     * @uses XRoutePattern::setUseCallingPartyPhoneMask()
     * @uses XRoutePattern::setDialPlanName()
     * @uses XRoutePattern::setDigitDiscardInstructionName()
     * @uses XRoutePattern::setNetworkLocation()
     * @uses XRoutePattern::setPrefixDigitsOut()
     * @uses XRoutePattern::setRouteFilterName()
     * @uses XRoutePattern::setDestination()
     * @uses XRoutePattern::setDescription()
     * @uses XRoutePattern::setCalledPartyTransformationMask()
     * @uses XRoutePattern::setCallingPartyTransformationMask()
     * @uses XRoutePattern::setCallingPartyPrefixDigits()
     * @uses XRoutePattern::setPatternUrgency()
     * @uses XRoutePattern::setCallingLinePresentationBit()
     * @uses XRoutePattern::setCallingNamePresentationBit()
     * @uses XRoutePattern::setConnectedLinePresentationBit()
     * @uses XRoutePattern::setConnectedNamePresentationBit()
     * @uses XRoutePattern::setSupportOverlapSending()
     * @uses XRoutePattern::setPatternPrecedence()
     * @uses XRoutePattern::setReleaseClause()
     * @uses XRoutePattern::setAllowDeviceOverride()
     * @uses XRoutePattern::setProvideOutsideDialtone()
     * @uses XRoutePattern::setCallingPartyNumberingPlan()
     * @uses XRoutePattern::setCallingPartyNumberType()
     * @uses XRoutePattern::setCalledPartyNumberingPlan()
     * @uses XRoutePattern::setCalledPartyNumberType()
     * @uses XRoutePattern::setAuthorizationCodeRequired()
     * @uses XRoutePattern::setAuthorizationLevelRequired()
     * @uses XRoutePattern::setClientCodeRequired()
     * @uses XRoutePattern::setIsdnNsfInfoElement()
     * @uses XRoutePattern::setResourcePriorityNamespaceName()
     * @uses XRoutePattern::setRouteClass()
     * @uses XRoutePattern::setEnableDccEnforcement()
     * @uses XRoutePattern::setBlockedCallPercentage()
     * @uses XRoutePattern::setExternalCallControl()
     * @param string $pattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $useCallingPartyPhoneMask
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $networkLocation
     * @param string $prefixDigitsOut
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @param string $description
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $callingPartyPrefixDigits
     * @param string $patternUrgency
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $supportOverlapSending
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $allowDeviceOverride
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param string $authorizationCodeRequired
     * @param string $authorizationLevelRequired
     * @param string $clientCodeRequired
     * @param \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @param string $routeClass
     * @param string $enableDccEnforcement
     * @param string $blockedCallPercentage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     */
    public function __construct($pattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $blockEnable = null, $useCallingPartyPhoneMask = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $networkLocation = 'OnNet', $prefixDigitsOut = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null, $description = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $callingPartyPrefixDigits = null, $patternUrgency = null, $callingLinePresentationBit = 'Default', $callingNamePresentationBit = 'Default', $connectedLinePresentationBit = 'Default', $connectedNamePresentationBit = 'Default', $supportOverlapSending = null, $patternPrecedence = 'Default', $releaseClause = 'No Error', $allowDeviceOverride = 'false', $provideOutsideDialtone = 'true', $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager', $authorizationCodeRequired = null, $authorizationLevelRequired = '0', $clientCodeRequired = null, \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null, $routeClass = 'Default', $enableDccEnforcement = null, $blockedCallPercentage = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setNetworkLocation($networkLocation)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setDestination($destination)
            ->setDescription($description)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPatternUrgency($patternUrgency)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSupportOverlapSending($supportOverlapSending)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setAllowDeviceOverride($allowDeviceOverride)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setAuthorizationCodeRequired($authorizationCodeRequired)
            ->setAuthorizationLevelRequired($authorizationLevelRequired)
            ->setClientCodeRequired($clientCodeRequired)
            ->setIsdnNsfInfoElement($isdnNsfInfoElement)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setEnableDccEnforcement($enableDccEnforcement)
            ->setBlockedCallPercentage($blockedCallPercentage)
            ->setExternalCallControl($externalCallControl);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockEnable, true), gettype($blockEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($blockEnable, true)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useCallingPartyPhoneMask) ? implode(', ', $useCallingPartyPhoneMask) : var_export($useCallingPartyPhoneMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setNetworkLocation($networkLocation = 'OnNet')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get destination value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Destination
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Destination $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setDestination(\Losc\CucmBundle\Model\Webservice\StructType\Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patternUrgency, true), gettype($patternUrgency)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($patternUrgency, true)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingLinePresentationBit) ? implode(', ', $callingLinePresentationBit) : var_export($callingLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($callingNamePresentationBit) ? implode(', ', $callingNamePresentationBit) : var_export($callingNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedLinePresentationBit) ? implode(', ', $connectedLinePresentationBit) : var_export($connectedLinePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit', is_array($connectedNamePresentationBit) ? implode(', ', $connectedNamePresentationBit) : var_export($connectedNamePresentationBit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get supportOverlapSending value
     * @return string|null
     */
    public function getSupportOverlapSending()
    {
        return $this->supportOverlapSending;
    }
    /**
     * Set supportOverlapSending value
     * @param string $supportOverlapSending
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setSupportOverlapSending($supportOverlapSending = null)
    {
        // validation for constraint: string
        if (!is_null($supportOverlapSending) && !is_string($supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supportOverlapSending, true), gettype($supportOverlapSending)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($supportOverlapSending) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($supportOverlapSending, true)), __LINE__);
        }
        $this->supportOverlapSending = $supportOverlapSending;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setReleaseClause($releaseClause = 'No Error')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue', is_array($releaseClause) ? implode(', ', $releaseClause) : var_export($releaseClause, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get allowDeviceOverride value
     * @return string|null
     */
    public function getAllowDeviceOverride()
    {
        return $this->allowDeviceOverride;
    }
    /**
     * Set allowDeviceOverride value
     * @param string $allowDeviceOverride
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setAllowDeviceOverride($allowDeviceOverride = 'false')
    {
        // validation for constraint: string
        if (!is_null($allowDeviceOverride) && !is_string($allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowDeviceOverride, true), gettype($allowDeviceOverride)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowDeviceOverride) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowDeviceOverride, true)), __LINE__);
        }
        $this->allowDeviceOverride = $allowDeviceOverride;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = 'true')
    {
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provideOutsideDialtone, true), gettype($provideOutsideDialtone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get authorizationCodeRequired value
     * @return string|null
     */
    public function getAuthorizationCodeRequired()
    {
        return $this->authorizationCodeRequired;
    }
    /**
     * Set authorizationCodeRequired value
     * @param string $authorizationCodeRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setAuthorizationCodeRequired($authorizationCodeRequired = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCodeRequired) && !is_string($authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCodeRequired, true), gettype($authorizationCodeRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($authorizationCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($authorizationCodeRequired, true)), __LINE__);
        }
        $this->authorizationCodeRequired = $authorizationCodeRequired;
        return $this;
    }
    /**
     * Get authorizationLevelRequired value
     * @return string|null
     */
    public function getAuthorizationLevelRequired()
    {
        return $this->authorizationLevelRequired;
    }
    /**
     * Set authorizationLevelRequired value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authorizationLevelRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setAuthorizationLevelRequired($authorizationLevelRequired = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($authorizationLevelRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($authorizationLevelRequired) ? implode(', ', $authorizationLevelRequired) : var_export($authorizationLevelRequired, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->authorizationLevelRequired = $authorizationLevelRequired;
        return $this;
    }
    /**
     * Get clientCodeRequired value
     * @return string|null
     */
    public function getClientCodeRequired()
    {
        return $this->clientCodeRequired;
    }
    /**
     * Set clientCodeRequired value
     * @param string $clientCodeRequired
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setClientCodeRequired($clientCodeRequired = null)
    {
        // validation for constraint: string
        if (!is_null($clientCodeRequired) && !is_string($clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCodeRequired, true), gettype($clientCodeRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($clientCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($clientCodeRequired, true)), __LINE__);
        }
        $this->clientCodeRequired = $clientCodeRequired;
        return $this;
    }
    /**
     * Get isdnNsfInfoElement value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement|null
     */
    public function getIsdnNsfInfoElement()
    {
        return $this->isdnNsfInfoElement;
    }
    /**
     * Set isdnNsfInfoElement value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setIsdnNsfInfoElement(\Losc\CucmBundle\Model\Webservice\StructType\IsdnNsfInfoElement $isdnNsfInfoElement = null)
    {
        $this->isdnNsfInfoElement = $isdnNsfInfoElement;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return isset($this->resourcePriorityNamespaceName) ? $this->resourcePriorityNamespaceName : null;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setResourcePriorityNamespaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceName = null)
    {
        if (is_null($resourcePriorityNamespaceName) || (is_array($resourcePriorityNamespaceName) && empty($resourcePriorityNamespaceName))) {
            unset($this->resourcePriorityNamespaceName);
        } else {
            $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        }
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setRouteClass($routeClass = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::valueIsValid($routeClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass', is_array($routeClass) ? implode(', ', $routeClass) : var_export($routeClass, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternRouteClass::getValidValues())), __LINE__);
        }
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get enableDccEnforcement value
     * @return string|null
     */
    public function getEnableDccEnforcement()
    {
        return $this->enableDccEnforcement;
    }
    /**
     * Set enableDccEnforcement value
     * @param string $enableDccEnforcement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setEnableDccEnforcement($enableDccEnforcement = null)
    {
        // validation for constraint: string
        if (!is_null($enableDccEnforcement) && !is_string($enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableDccEnforcement, true), gettype($enableDccEnforcement)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableDccEnforcement) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableDccEnforcement, true)), __LINE__);
        }
        $this->enableDccEnforcement = $enableDccEnforcement;
        return $this;
    }
    /**
     * Get blockedCallPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBlockedCallPercentage()
    {
        return isset($this->blockedCallPercentage) ? $this->blockedCallPercentage : null;
    }
    /**
     * Set blockedCallPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $blockedCallPercentage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setBlockedCallPercentage($blockedCallPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($blockedCallPercentage) && !is_string($blockedCallPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockedCallPercentage, true), gettype($blockedCallPercentage)), __LINE__);
        }
        if (is_null($blockedCallPercentage) || (is_array($blockedCallPercentage) && empty($blockedCallPercentage))) {
            unset($this->blockedCallPercentage);
        } else {
            $this->blockedCallPercentage = $blockedCallPercentage;
        }
        return $this;
    }
    /**
     * Get externalCallControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExternalCallControl()
    {
        return isset($this->externalCallControl) ? $this->externalCallControl : null;
    }
    /**
     * Set externalCallControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRoutePattern
     */
    public function setExternalCallControl(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $externalCallControl = null)
    {
        if (is_null($externalCallControl) || (is_array($externalCallControl) && empty($externalCallControl))) {
            unset($this->externalCallControl);
        } else {
            $this->externalCallControl = $externalCallControl;
        }
        return $this;
    }
}
