<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteDestination StructType
 * @subpackage Structs
 */
class XRemoteDestination extends AbstractStructBase
{
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $destination;
    /**
     * The answerTooSoonTimer
     * Meta information extracted from the WSDL
     * - default: 1500
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta information extracted from the WSDL
     * - default: 19000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta information extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The ownerUserId
     * Meta information extracted from the WSDL
     * - documentation: From 10.5, to get proper value of this tag in get handler's response it is required to have value of todaccess, in case if user does not give any value in todaccesss tag, axl will insert a random row so that get handler response can
     * return proper value of Owner User id
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserId;
    /**
     * The remoteDestinationProfileName
     * Meta information extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The dualModeDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dualModeDeviceName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The enableUnifiedMobility
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete enable Unified Mobility feature.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUnifiedMobility;
    /**
     * The enableExtendAndConnect
     * Meta information extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete Enable Extend and Connect.Use only while update
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtendAndConnect;
    /**
     * The ctiRemoteDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ctiRemoteDeviceName;
    /**
     * The isMobilePhone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - default: Etc/GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta information extracted from the WSDL
     * - documentation: From 10.5 version if a user doesn't specify a value in this tag, AXL will still insert a random row in todaccess because value in todaccess is required to fetch value of owner user id properly in get handler
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta information extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityProfileName;
    /**
     * The singleNumberReachVoicemail
     * Meta information extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleNumberReachVoicemail;
    /**
     * The dialViaOfficeReverseVoicemail
     * Meta information extracted from the WSDL
     * - documentation: This tag is for Mobility Identity
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dialViaOfficeReverseVoicemail;
    /**
     * Constructor method for XRemoteDestination
     * @uses XRemoteDestination::setDestination()
     * @uses XRemoteDestination::setAnswerTooSoonTimer()
     * @uses XRemoteDestination::setAnswerTooLateTimer()
     * @uses XRemoteDestination::setDelayBeforeRingingCell()
     * @uses XRemoteDestination::setOwnerUserId()
     * @uses XRemoteDestination::setRemoteDestinationProfileName()
     * @uses XRemoteDestination::setDualModeDeviceName()
     * @uses XRemoteDestination::setName()
     * @uses XRemoteDestination::setEnableUnifiedMobility()
     * @uses XRemoteDestination::setEnableExtendAndConnect()
     * @uses XRemoteDestination::setCtiRemoteDeviceName()
     * @uses XRemoteDestination::setIsMobilePhone()
     * @uses XRemoteDestination::setEnableMobileConnect()
     * @uses XRemoteDestination::setLineAssociations()
     * @uses XRemoteDestination::setTimeZone()
     * @uses XRemoteDestination::setTodAccessName()
     * @uses XRemoteDestination::setMobileSmartClientName()
     * @uses XRemoteDestination::setMobilityProfileName()
     * @uses XRemoteDestination::setSingleNumberReachVoicemail()
     * @uses XRemoteDestination::setDialViaOfficeReverseVoicemail()
     * @param string $destination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName
     * @param string $name
     * @param string $enableUnifiedMobility
     * @param string $enableExtendAndConnect
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations
     * @param string $timeZone
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName
     * @param string $singleNumberReachVoicemail
     * @param string $dialViaOfficeReverseVoicemail
     */
    public function __construct($destination = null, $answerTooSoonTimer = '1500', $answerTooLateTimer = '19000', $delayBeforeRingingCell = '4000', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName = null, $name = null, $enableUnifiedMobility = null, $enableExtendAndConnect = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName = null, $isMobilePhone = 'false', $enableMobileConnect = 'true', \Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations = null, $timeZone = 'Etc/GMT', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName = null, $singleNumberReachVoicemail = 'Use System Default', $dialViaOfficeReverseVoicemail = 'Use System Default')
    {
        $this
            ->setDestination($destination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setOwnerUserId($ownerUserId)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setName($name)
            ->setEnableUnifiedMobility($enableUnifiedMobility)
            ->setEnableExtendAndConnect($enableExtendAndConnect)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName)
            ->setSingleNumberReachVoicemail($singleNumberReachVoicemail)
            ->setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail);
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = '1500')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($answerTooSoonTimer) ? implode(', ', $answerTooSoonTimer) : var_export($answerTooSoonTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = '19000')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($answerTooLateTimer) ? implode(', ', $answerTooLateTimer) : var_export($answerTooLateTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = '4000')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($delayBeforeRingingCell) ? implode(', ', $delayBeforeRingingCell) : var_export($delayBeforeRingingCell, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setOwnerUserId(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRemoteDestinationProfileName()
    {
        return $this->remoteDestinationProfileName;
    }
    /**
     * Set remoteDestinationProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setRemoteDestinationProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $remoteDestinationProfileName = null)
    {
        $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDualModeDeviceName()
    {
        return $this->dualModeDeviceName;
    }
    /**
     * Set dualModeDeviceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setDualModeDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dualModeDeviceName = null)
    {
        $this->dualModeDeviceName = $dualModeDeviceName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get enableUnifiedMobility value
     * @return string|null
     */
    public function getEnableUnifiedMobility()
    {
        return $this->enableUnifiedMobility;
    }
    /**
     * Set enableUnifiedMobility value
     * @param string $enableUnifiedMobility
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setEnableUnifiedMobility($enableUnifiedMobility = null)
    {
        // validation for constraint: string
        if (!is_null($enableUnifiedMobility) && !is_string($enableUnifiedMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableUnifiedMobility, true), gettype($enableUnifiedMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableUnifiedMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUnifiedMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableUnifiedMobility, true)), __LINE__);
        }
        $this->enableUnifiedMobility = $enableUnifiedMobility;
        return $this;
    }
    /**
     * Get enableExtendAndConnect value
     * @return string|null
     */
    public function getEnableExtendAndConnect()
    {
        return $this->enableExtendAndConnect;
    }
    /**
     * Set enableExtendAndConnect value
     * @param string $enableExtendAndConnect
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setEnableExtendAndConnect($enableExtendAndConnect = null)
    {
        // validation for constraint: string
        if (!is_null($enableExtendAndConnect) && !is_string($enableExtendAndConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableExtendAndConnect, true), gettype($enableExtendAndConnect)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableExtendAndConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtendAndConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableExtendAndConnect, true)), __LINE__);
        }
        $this->enableExtendAndConnect = $enableExtendAndConnect;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCtiRemoteDeviceName()
    {
        return isset($this->ctiRemoteDeviceName) ? $this->ctiRemoteDeviceName : null;
    }
    /**
     * Set ctiRemoteDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setCtiRemoteDeviceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ctiRemoteDeviceName = null)
    {
        if (is_null($ctiRemoteDeviceName) || (is_array($ctiRemoteDeviceName) && empty($ctiRemoteDeviceName))) {
            unset($this->ctiRemoteDeviceName);
        } else {
            $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        }
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setIsMobilePhone($isMobilePhone = 'false')
    {
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isMobilePhone, true), gettype($isMobilePhone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isMobilePhone, true)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setEnableMobileConnect($enableMobileConnect = 'true')
    {
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobileConnect, true), gettype($enableMobileConnect)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobileConnect, true)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setLineAssociations(\Losc\CucmBundle\Model\Webservice\StructType\LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodAccessName()
    {
        return isset($this->todAccessName) ? $this->todAccessName : null;
    }
    /**
     * Set todAccessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setTodAccessName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todAccessName = null)
    {
        if (is_null($todAccessName) || (is_array($todAccessName) && empty($todAccessName))) {
            unset($this->todAccessName);
        } else {
            $this->todAccessName = $todAccessName;
        }
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return isset($this->mobileSmartClientName) ? $this->mobileSmartClientName : null;
    }
    /**
     * Set mobileSmartClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setMobileSmartClientName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientName = null)
    {
        if (is_null($mobileSmartClientName) || (is_array($mobileSmartClientName) && empty($mobileSmartClientName))) {
            unset($this->mobileSmartClientName);
        } else {
            $this->mobileSmartClientName = $mobileSmartClientName;
        }
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityProfileName()
    {
        return isset($this->mobilityProfileName) ? $this->mobilityProfileName : null;
    }
    /**
     * Set mobilityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setMobilityProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityProfileName = null)
    {
        if (is_null($mobilityProfileName) || (is_array($mobilityProfileName) && empty($mobilityProfileName))) {
            unset($this->mobilityProfileName);
        } else {
            $this->mobilityProfileName = $mobilityProfileName;
        }
        return $this;
    }
    /**
     * Get singleNumberReachVoicemail value
     * @return string|null
     */
    public function getSingleNumberReachVoicemail()
    {
        return $this->singleNumberReachVoicemail;
    }
    /**
     * Set singleNumberReachVoicemail value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleNumberReachVoicemail
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setSingleNumberReachVoicemail($singleNumberReachVoicemail = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::valueIsValid($singleNumberReachVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy', is_array($singleNumberReachVoicemail) ? implode(', ', $singleNumberReachVoicemail) : var_export($singleNumberReachVoicemail, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->singleNumberReachVoicemail = $singleNumberReachVoicemail;
        return $this;
    }
    /**
     * Get dialViaOfficeReverseVoicemail value
     * @return string|null
     */
    public function getDialViaOfficeReverseVoicemail()
    {
        return $this->dialViaOfficeReverseVoicemail;
    }
    /**
     * Set dialViaOfficeReverseVoicemail value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialViaOfficeReverseVoicemail
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestination
     */
    public function setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::valueIsValid($dialViaOfficeReverseVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy', is_array($dialViaOfficeReverseVoicemail) ? implode(', ', $dialViaOfficeReverseVoicemail) : var_export($dialViaOfficeReverseVoicemail, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->dialViaOfficeReverseVoicemail = $dialViaOfficeReverseVoicemail;
        return $this;
    }
}
