<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRegionMatrix StructType
 * @subpackage Structs
 */
class XRegionMatrix extends AbstractStructBase
{
    /**
     * The regionAName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionBName;
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoBandwidth;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $codecPreference;
    /**
     * Constructor method for XRegionMatrix
     * @uses XRegionMatrix::setRegionAName()
     * @uses XRegionMatrix::setRegionBName()
     * @uses XRegionMatrix::setBandwidth()
     * @uses XRegionMatrix::setVideoBandwidth()
     * @uses XRegionMatrix::setCodecPreference()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null, $bandwidth = null, $videoBandwidth = '384', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        $this
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setCodecPreference($codecPreference);
    }
    /**
     * Get regionAName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionAName()
    {
        return $this->regionAName;
    }
    /**
     * Set regionAName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegionMatrix
     */
    public function setRegionAName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null)
    {
        $this->regionAName = $regionAName;
        return $this;
    }
    /**
     * Get regionBName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionBName()
    {
        return $this->regionBName;
    }
    /**
     * Set regionBName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegionMatrix
     */
    public function setRegionBName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null)
    {
        $this->regionBName = $regionBName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegionMatrix
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegionMatrix
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($videoBandwidth) ? implode(', ', $videoBandwidth) : var_export($videoBandwidth, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get codecPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return isset($this->codecPreference) ? $this->codecPreference : null;
    }
    /**
     * Set codecPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XRegionMatrix
     */
    public function setCodecPreference(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        if (is_null($codecPreference) || (is_array($codecPreference) && empty($codecPreference))) {
            unset($this->codecPreference);
        } else {
            $this->codecPreference = $codecPreference;
        }
        return $this;
    }
}
