<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XProcessNode StructType
 * @subpackage Structs
 */
class XProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - default: CUCM Voice/Video
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $processNodeRole;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Name;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The cupDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * Constructor method for XProcessNode
     * @uses XProcessNode::setName()
     * @uses XProcessNode::setProcessNodeRole()
     * @uses XProcessNode::setDescription()
     * @uses XProcessNode::setMac()
     * @uses XProcessNode::setIpv6Name()
     * @uses XProcessNode::setLbmHubGroup()
     * @uses XProcessNode::setCupDomain()
     * @param string $name
     * @param string $processNodeRole
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @param string $cupDomain
     */
    public function __construct($name = null, $processNodeRole = 'CUCM Voice/Video', $description = null, $mac = null, $ipv6Name = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null, $cupDomain = null)
    {
        $this
            ->setName($name)
            ->setProcessNodeRole($processNodeRole)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setLbmHubGroup($lbmHubGroup)
            ->setCupDomain($cupDomain);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processNodeRole
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setProcessNodeRole($processNodeRole = 'CUCM Voice/Video')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::valueIsValid($processNodeRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole', is_array($processNodeRole) ? implode(', ', $processNodeRole) : var_export($processNodeRole, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProcessNodeRole::getValidValues())), __LINE__);
        }
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mac, true), gettype($mac)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|[a-f]|[A-F]){12})
        if (!is_null($mac) && !preg_match('/([0-9]|[a-f]|[A-F]){12}/', $mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|[a-f]|[A-F]){12}', var_export($mac, true)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Name) && !is_string($ipv6Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv6Name, true), gettype($ipv6Name)), __LINE__);
        }
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return isset($this->lbmHubGroup) ? $this->lbmHubGroup : null;
    }
    /**
     * Set lbmHubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setLbmHubGroup(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null)
    {
        if (is_null($lbmHubGroup) || (is_array($lbmHubGroup) && empty($lbmHubGroup))) {
            unset($this->lbmHubGroup);
        } else {
            $this->lbmHubGroup = $lbmHubGroup;
        }
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setCupDomain($cupDomain = null)
    {
        // validation for constraint: string
        if (!is_null($cupDomain) && !is_string($cupDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cupDomain, true), gettype($cupDomain)), __LINE__);
        }
        $this->cupDomain = $cupDomain;
        return $this;
    }
}
