<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPresenceRedundancyGroup StructType
 * @subpackage Structs
 */
class XPresenceRedundancyGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The server1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $server1;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The server2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $server2;
    /**
     * The haEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $haEnabled;
    /**
     * Constructor method for XPresenceRedundancyGroup
     * @uses XPresenceRedundancyGroup::setName()
     * @uses XPresenceRedundancyGroup::setServer1()
     * @uses XPresenceRedundancyGroup::setDescription()
     * @uses XPresenceRedundancyGroup::setServer2()
     * @uses XPresenceRedundancyGroup::setHaEnabled()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server1
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server2
     * @param string $haEnabled
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server1 = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server2 = null, $haEnabled = 'false')
    {
        $this
            ->setName($name)
            ->setServer1($server1)
            ->setDescription($description)
            ->setServer2($server2)
            ->setHaEnabled($haEnabled);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPresenceRedundancyGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get server1 value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getServer1()
    {
        return $this->server1;
    }
    /**
     * Set server1 value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server1
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPresenceRedundancyGroup
     */
    public function setServer1(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $server1 = null)
    {
        $this->server1 = $server1;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPresenceRedundancyGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get server2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServer2()
    {
        return isset($this->server2) ? $this->server2 : null;
    }
    /**
     * Set server2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $server2
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPresenceRedundancyGroup
     */
    public function setServer2(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $server2 = null)
    {
        if (is_null($server2) || (is_array($server2) && empty($server2))) {
            unset($this->server2);
        } else {
            $this->server2 = $server2;
        }
        return $this;
    }
    /**
     * Get haEnabled value
     * @return string|null
     */
    public function getHaEnabled()
    {
        return $this->haEnabled;
    }
    /**
     * Set haEnabled value
     * @param string $haEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPresenceRedundancyGroup
     */
    public function setHaEnabled($haEnabled = 'false')
    {
        // validation for constraint: string
        if (!is_null($haEnabled) && !is_string($haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($haEnabled, true), gettype($haEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($haEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($haEnabled, true)), __LINE__);
        }
        $this->haEnabled = $haEnabled;
        return $this;
    }
}
