<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPickupGroupMember StructType
 * @subpackage Structs
 */
class XPickupGroupMember extends AbstractStructBase
{
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * The pickupGroupName
     * Meta information extracted from the WSDL
     * - choice: pickupGroupName | pickupDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $pickupGroupName;
    /**
     * The pickupDnAndPartition
     * Meta information extracted from the WSDL
     * - choice: pickupGroupName | pickupDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition
     */
    public $pickupDnAndPartition;
    /**
     * Constructor method for XPickupGroupMember
     * @uses XPickupGroupMember::setPriority()
     * @uses XPickupGroupMember::setPickupGroupName()
     * @uses XPickupGroupMember::setPickupDnAndPartition()
     * @param string $priority
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $pickupGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition $pickupDnAndPartition
     */
    public function __construct($priority = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $pickupGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this
            ->setPriority($priority)
            ->setPickupGroupName($pickupGroupName)
            ->setPickupDnAndPartition($pickupDnAndPartition);
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPickupGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get pickupGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPickupGroupName()
    {
        return isset($this->pickupGroupName) ? $this->pickupGroupName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPickupGroupName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupGroupName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePickupGroupNameForChoiceConstraintsFromSetPickupGroupName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pickupDnAndPartition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pickupGroupName can\'t be set as the property %s is already set. Only one property must be set among these properties: pickupGroupName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pickupGroupName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $pickupGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPickupGroupMember
     */
    public function setPickupGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $pickupGroupName = null)
    {
        // validation for constraint: choice(pickupGroupName, pickupDnAndPartition)
        if ('' !== ($pickupGroupNameChoiceErrorMessage = self::validatePickupGroupNameForChoiceConstraintsFromSetPickupGroupName($pickupGroupName))) {
            throw new \InvalidArgumentException($pickupGroupNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($pickupGroupName) || (is_array($pickupGroupName) && empty($pickupGroupName))) {
            unset($this->pickupGroupName);
        } else {
            $this->pickupGroupName = $pickupGroupName;
        }
        return $this;
    }
    /**
     * Get pickupDnAndPartition value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition
     */
    public function getPickupDnAndPartition()
    {
        return isset($this->pickupDnAndPartition) ? $this->pickupDnAndPartition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPickupDnAndPartition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPickupDnAndPartition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePickupDnAndPartitionForChoiceConstraintsFromSetPickupDnAndPartition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pickupGroupName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pickupDnAndPartition can\'t be set as the property %s is already set. Only one property must be set among these properties: pickupDnAndPartition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pickupDnAndPartition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition $pickupDnAndPartition
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XPickupGroupMember
     */
    public function setPickupDnAndPartition(\Losc\CucmBundle\Model\Webservice\StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        // validation for constraint: choice(pickupGroupName, pickupDnAndPartition)
        if ('' !== ($pickupDnAndPartitionChoiceErrorMessage = self::validatePickupDnAndPartitionForChoiceConstraintsFromSetPickupDnAndPartition($pickupDnAndPartition))) {
            throw new \InvalidArgumentException($pickupDnAndPartitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($pickupDnAndPartition) || (is_array($pickupDnAndPartition) && empty($pickupDnAndPartition))) {
            unset($this->pickupDnAndPartition);
        } else {
            $this->pickupDnAndPartition = $pickupDnAndPartition;
        }
        return $this;
    }
}
