<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XParameterMember StructType
 * @subpackage Structs
 */
class XParameterMember extends AbstractStructBase
{
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $selectionOrder;
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for XParameterMember
     * @uses XParameterMember::setSelectionOrder()
     * @uses XParameterMember::setParameter()
     * @uses XParameterMember::setValue()
     * @param string $selectionOrder
     * @param string $parameter
     * @param string $value
     */
    public function __construct($selectionOrder = '0', $parameter = null, $value = null)
    {
        $this
            ->setSelectionOrder($selectionOrder)
            ->setParameter($parameter)
            ->setValue($value);
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XParameterMember
     */
    public function setSelectionOrder($selectionOrder = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialParameter::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDialParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameter
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XParameterMember
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDialParameter::valueIsValid($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDialParameter', is_array($parameter) ? implode(', ', $parameter) : var_export($parameter, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDialParameter::getValidValues())), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XParameterMember
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
