<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocationRelationship StructType
 * @subpackage Structs
 */
class XLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rsvpSetting;
    /**
     * Constructor method for XLocationRelationship
     * @uses XLocationRelationship::setLocationName()
     * @uses XLocationRelationship::setRsvpSetting()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $rsvpSetting
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $rsvpSetting = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting);
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLocationRelationship
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue', is_array($rsvpSetting) ? implode(', ', $rsvpSetting) : var_export($rsvpSetting, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
}
