<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeClient StructType
 * @subpackage Structs
 */
class XImeClient extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domain;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryImeServerName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The secondaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $firewallName;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The ccmExternalIpMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * Constructor method for XImeClient
     * @uses XImeClient::setName()
     * @uses XImeClient::setDomain()
     * @uses XImeClient::setSipTrunkName()
     * @uses XImeClient::setPrimaryImeServerName()
     * @uses XImeClient::setDescription()
     * @uses XImeClient::setIsActivated()
     * @uses XImeClient::setSecondaryImeServerName()
     * @uses XImeClient::setLearnedRouteFilterGroupName()
     * @uses XImeClient::setExclusionNumberGroupName()
     * @uses XImeClient::setFirewallName()
     * @uses XImeClient::setMembers()
     * @uses XImeClient::setCcmExternalIpMaps()
     * @param string $name
     * @param string $domain
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName
     * @param string $description
     * @param string $isActivated
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps $ccmExternalIpMaps
     */
    public function __construct($name = null, $domain = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName = null, $description = null, $isActivated = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, \Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this
            ->setName($name)
            ->setDomain($domain)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setMembers($members)
            ->setCcmExternalIpMaps($ccmExternalIpMaps);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get domain value
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($domain) && mb_strlen($domain) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setSipTrunkName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setPrimaryImeServerName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setIsActivated($isActivated = 'false')
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return isset($this->secondaryImeServerName) ? $this->secondaryImeServerName : null;
    }
    /**
     * Set secondaryImeServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setSecondaryImeServerName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName = null)
    {
        if (is_null($secondaryImeServerName) || (is_array($secondaryImeServerName) && empty($secondaryImeServerName))) {
            unset($this->secondaryImeServerName);
        } else {
            $this->secondaryImeServerName = $secondaryImeServerName;
        }
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return isset($this->learnedRouteFilterGroupName) ? $this->learnedRouteFilterGroupName : null;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setLearnedRouteFilterGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName = null)
    {
        if (is_null($learnedRouteFilterGroupName) || (is_array($learnedRouteFilterGroupName) && empty($learnedRouteFilterGroupName))) {
            unset($this->learnedRouteFilterGroupName);
        } else {
            $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        }
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return isset($this->exclusionNumberGroupName) ? $this->exclusionNumberGroupName : null;
    }
    /**
     * Set exclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setExclusionNumberGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName = null)
    {
        if (is_null($exclusionNumberGroupName) || (is_array($exclusionNumberGroupName) && empty($exclusionNumberGroupName))) {
            unset($this->exclusionNumberGroupName);
        } else {
            $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Get firewallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFirewallName()
    {
        return isset($this->firewallName) ? $this->firewallName : null;
    }
    /**
     * Set firewallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setFirewallName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName = null)
    {
        if (is_null($firewallName) || (is_array($firewallName) && empty($firewallName))) {
            unset($this->firewallName);
        } else {
            $this->firewallName = $firewallName;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps $ccmExternalIpMaps
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XImeClient
     */
    public function setCcmExternalIpMaps(\Losc\CucmBundle\Model\Webservice\StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
}
