<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFeatureGroupTemplate StructType
 * @subpackage Structs
 */
class XFeatureGroupTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The maxDeskPickupWait
     * Meta information extracted from the WSDL
     * - default: 10000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxDeskPickupWait;
    /**
     * The remoteDestinationLimit
     * Meta information extracted from the WSDL
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The BLFPresenceGp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $BLFPresenceGp;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The homeCluster
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndUcPresenceEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndUcPresenceEnable;
    /**
     * The serviceProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The allowCTIControl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCTIControl;
    /**
     * The enableEMCC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEMCC;
    /**
     * The enableMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The subscribeCallingSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearch;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The userProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $userProfile;
    /**
     * The meetingInformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $meetingInformation;
    /**
     * Constructor method for XFeatureGroupTemplate
     * @uses XFeatureGroupTemplate::setName()
     * @uses XFeatureGroupTemplate::setMaxDeskPickupWait()
     * @uses XFeatureGroupTemplate::setRemoteDestinationLimit()
     * @uses XFeatureGroupTemplate::setBLFPresenceGp()
     * @uses XFeatureGroupTemplate::setDescription()
     * @uses XFeatureGroupTemplate::setHomeCluster()
     * @uses XFeatureGroupTemplate::setImAndUcPresenceEnable()
     * @uses XFeatureGroupTemplate::setServiceProfile()
     * @uses XFeatureGroupTemplate::setAllowCTIControl()
     * @uses XFeatureGroupTemplate::setEnableEMCC()
     * @uses XFeatureGroupTemplate::setEnableMobility()
     * @uses XFeatureGroupTemplate::setEnableMobileVoiceAccess()
     * @uses XFeatureGroupTemplate::setSubscribeCallingSearch()
     * @uses XFeatureGroupTemplate::setUserLocale()
     * @uses XFeatureGroupTemplate::setUserProfile()
     * @uses XFeatureGroupTemplate::setMeetingInformation()
     * @param string $name
     * @param string $maxDeskPickupWait
     * @param string $remoteDestinationLimit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp
     * @param string $description
     * @param string $homeCluster
     * @param string $imAndUcPresenceEnable
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @param string $allowCTIControl
     * @param string $enableEMCC
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch
     * @param string $userLocale
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @param string $meetingInformation
     */
    public function __construct($name = null, $maxDeskPickupWait = '10000', $remoteDestinationLimit = '4', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp = null, $description = null, $homeCluster = null, $imAndUcPresenceEnable = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null, $allowCTIControl = null, $enableEMCC = null, $enableMobility = null, $enableMobileVoiceAccess = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch = null, $userLocale = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null, $meetingInformation = null)
    {
        $this
            ->setName($name)
            ->setMaxDeskPickupWait($maxDeskPickupWait)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setBLFPresenceGp($bLFPresenceGp)
            ->setDescription($description)
            ->setHomeCluster($homeCluster)
            ->setImAndUcPresenceEnable($imAndUcPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setAllowCTIControl($allowCTIControl)
            ->setEnableEMCC($enableEMCC)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setSubscribeCallingSearch($subscribeCallingSearch)
            ->setUserLocale($userLocale)
            ->setUserProfile($userProfile)
            ->setMeetingInformation($meetingInformation);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get maxDeskPickupWait value
     * @return string
     */
    public function getMaxDeskPickupWait()
    {
        return $this->maxDeskPickupWait;
    }
    /**
     * Set maxDeskPickupWait value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWait
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setMaxDeskPickupWait($maxDeskPickupWait = '10000')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxDeskPickupWait)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxDeskPickupWait) ? implode(', ', $maxDeskPickupWait) : var_export($maxDeskPickupWait, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWait = $maxDeskPickupWait;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = '4')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($remoteDestinationLimit) ? implode(', ', $remoteDestinationLimit) : var_export($remoteDestinationLimit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get BLFPresenceGp value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getBLFPresenceGp()
    {
        return $this->BLFPresenceGp;
    }
    /**
     * Set BLFPresenceGp value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setBLFPresenceGp(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $bLFPresenceGp = null)
    {
        $this->BLFPresenceGp = $bLFPresenceGp;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setHomeCluster($homeCluster = null)
    {
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCluster, true), gettype($homeCluster)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($homeCluster, true)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndUcPresenceEnable value
     * @return string|null
     */
    public function getImAndUcPresenceEnable()
    {
        return $this->imAndUcPresenceEnable;
    }
    /**
     * Set imAndUcPresenceEnable value
     * @param string $imAndUcPresenceEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setImAndUcPresenceEnable($imAndUcPresenceEnable = null)
    {
        // validation for constraint: string
        if (!is_null($imAndUcPresenceEnable) && !is_string($imAndUcPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imAndUcPresenceEnable, true), gettype($imAndUcPresenceEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($imAndUcPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndUcPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($imAndUcPresenceEnable, true)), __LINE__);
        }
        $this->imAndUcPresenceEnable = $imAndUcPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return isset($this->serviceProfile) ? $this->serviceProfile : null;
    }
    /**
     * Set serviceProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setServiceProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null)
    {
        if (is_null($serviceProfile) || (is_array($serviceProfile) && empty($serviceProfile))) {
            unset($this->serviceProfile);
        } else {
            $this->serviceProfile = $serviceProfile;
        }
        return $this;
    }
    /**
     * Get allowCTIControl value
     * @return string|null
     */
    public function getAllowCTIControl()
    {
        return $this->allowCTIControl;
    }
    /**
     * Set allowCTIControl value
     * @param string $allowCTIControl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setAllowCTIControl($allowCTIControl = null)
    {
        // validation for constraint: string
        if (!is_null($allowCTIControl) && !is_string($allowCTIControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowCTIControl, true), gettype($allowCTIControl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowCTIControl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCTIControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowCTIControl, true)), __LINE__);
        }
        $this->allowCTIControl = $allowCTIControl;
        return $this;
    }
    /**
     * Get enableEMCC value
     * @return string|null
     */
    public function getEnableEMCC()
    {
        return $this->enableEMCC;
    }
    /**
     * Set enableEMCC value
     * @param string $enableEMCC
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setEnableEMCC($enableEMCC = null)
    {
        // validation for constraint: string
        if (!is_null($enableEMCC) && !is_string($enableEMCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableEMCC, true), gettype($enableEMCC)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableEMCC) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEMCC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableEMCC, true)), __LINE__);
        }
        $this->enableEMCC = $enableEMCC;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setEnableMobility($enableMobility = null)
    {
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobility, true), gettype($enableMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobility, true)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobileVoiceAccess, true), gettype($enableMobileVoiceAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get subscribeCallingSearch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearch()
    {
        return isset($this->subscribeCallingSearch) ? $this->subscribeCallingSearch : null;
    }
    /**
     * Set subscribeCallingSearch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setSubscribeCallingSearch(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearch = null)
    {
        if (is_null($subscribeCallingSearch) || (is_array($subscribeCallingSearch) && empty($subscribeCallingSearch))) {
            unset($this->subscribeCallingSearch);
        } else {
            $this->subscribeCallingSearch = $subscribeCallingSearch;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get userProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return isset($this->userProfile) ? $this->userProfile : null;
    }
    /**
     * Set userProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setUserProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null)
    {
        if (is_null($userProfile) || (is_array($userProfile) && empty($userProfile))) {
            unset($this->userProfile);
        } else {
            $this->userProfile = $userProfile;
        }
        return $this;
    }
    /**
     * Get meetingInformation value
     * @return string|null
     */
    public function getMeetingInformation()
    {
        return $this->meetingInformation;
    }
    /**
     * Set meetingInformation value
     * @param string $meetingInformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureGroupTemplate
     */
    public function setMeetingInformation($meetingInformation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingInformation) && !is_string($meetingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingInformation, true), gettype($meetingInformation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($meetingInformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $meetingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($meetingInformation, true)), __LINE__);
        }
        $this->meetingInformation = $meetingInformation;
        return $this;
    }
}
